package com.fshows.ysepay.request.income;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 签约短信/邮件通知请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayIncomeSignSendMsgRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -2353528081713544090L;
    /**
     * 签约流水号
     * 字节长度: String(20)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 20)
    private String signId;

    /**
     * 通知方式
     * 0 短信+邮件
     * 1 短信
     * 2 邮件
     * 3 不通知
     * 字节长度: String(1)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 1)
    private String isSendConMsg;
} 