package com.fshows.ysepay.request.income;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.fshows.ysepay.model.income.BusInfo;
import com.fshows.ysepay.model.income.CrpInfo;
import com.fshows.ysepay.model.income.CustInfo;
import com.fshows.ysepay.model.income.StlAccInfo;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户资料变更请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayIncomeModifyCustInfoApplyRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -8905203537756069651L;
    /**
     * 入网申请流水
     * 字节长度: String(25)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 25)
    private String sysFlowId;

    /**
     * 基本信息
     * 必填: 是
     */
    @NotNull
    private CustInfo custInfo;

    /**
     * 法人信息
     * 必填: 是
     */
    @NotNull
    private CrpInfo crpInfo;

    /**
     * 结算信息
     * 必填: 是
     */
    @NotNull
    private StlAccInfo stlAccInfo;

    /**
     * 营业信息
     * 必填: 是
     */
    @NotNull
    private BusInfo busInfo;
} 