/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.ysepay.request.income;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.File;

/**
 * @author mengqf
 * @version YsepayIncomeFileBizRequest.java, v 0.1 2025-06-10 10:08 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class YsepayIncomeFileBizRequest extends YsepayIncomeBizRequest {
    /**
     * 图片文件
     * 将媒体图片进行二进制转换的内容
     * 必填: 是
     * // 示例代码
     * File file = new File("path/to/image.jpg");
     * byte[] fileContent = Files.readAllBytes(file.toPath());
     * request.setFile(fileContent);
     */
    @NotNull(message = "文件内容不能为空")
    @JSONField(serialize=false)
    private File file;
}