package com.fshows.ysepay.request.income;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 银盛支付基础请求类
 */
@Data
public class YsepayIncomeBizRequest implements IRequestDefinition {
	/**
	 * 发起方商户号，服务商在银盛给自己开设的商户号，即可当作发起方商户号，由银盛生成并下发。 注意：不同于子商户号，服务商发展的商户即为子商户号
	 */
	@NotBlank
	private String certId;
}