package com.fshows.ysepay.request.income;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户资料审核请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayIncomeAuditCustInfoApplyRequest extends YsepayIncomeBizRequest {

    /**
     * 审核标志
     * Y通过,N拒绝
     * 字节长度: String(1)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 1)
    private String auditFlag;

    /**
     * 入网申请流水号
     * 字节长度: String(25)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 25)
    private String sysFlowId;
} 