package com.fshows.ysepay.request.income;

import com.fshows.ysepay.model.income.CustInfo;
import com.fshows.ysepay.model.income.CrpInfo;
import com.fshows.ysepay.model.income.StlAccInfo;
import com.fshows.ysepay.model.income.BusInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 商户进件请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayIncomeAddCustInfoApplyRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -5354288492956104636L;
    /**
     * 基本信息
     * 必填: 是
     */
    @NotNull
    private CustInfo custInfo;

    /**
     * 法人信息
     * 必填: 是
     */
    @NotNull
    private CrpInfo crpInfo;

    /**
     * 结算信息
     * 必填: 是
     */
    @NotNull
    private StlAccInfo stlAccInfo;

    /**
     * 营业信息
     * 必填: 是
     */
    @NotNull
    private BusInfo busInfo;

    /**
     * 业务方入网申请流水号
     * 唯一（商户状态查询接口可通过此字段查询）
     * 字节长度: String(32)
     * 必填: 否
     */
    @Size(max = 32)
    private String thirdFlowId;
} 