package com.fshows.ysepay.request.income;

import java.util.List;

import javax.validation.constraints.Size;

import com.fshows.ysepay.model.income.fee.CodeScanT1Fee;
import com.fshows.ysepay.model.income.fee.D0BaseFee;
import com.fshows.ysepay.model.income.fee.OutCardFee;
import com.fshows.ysepay.model.income.fee.SwCardD0Fee;
import com.fshows.ysepay.model.income.fee.SwCardT1Fee;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 费率信息变更请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayChangeRateRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = 2240340126207770773L;
    /**
     * 扫码工作日到账费率
     * busOpenType=00时必填
     */
    private CodeScanT1Fee codeScanT1Fee;
    
    /**
     * 扫码实时到账垫资费
     * busOpenType=01时必填
     */
    private D0BaseFee codeScanD0Fee;
    
    /**
     * 刷卡工作日到账费率
     * busOpenType=10时必填
     */
    private SwCardT1Fee swCardT1Fee;
    
    /**
     * 刷卡实时到账垫资费
     * busOpenType=11时必填
     */
    private SwCardD0Fee swCardD0Fee;
    
    /**
     * 天天到账垫资费
     * busOpenType=20时必填
     */
    private D0BaseFee d1Fee;
    
    /**
     * T+2到账费率(境外卡)
     * busOpenType=21时必填，连通境外卡为T+1到账
     */
    private List<OutCardFee> outCardFeeList;
    
    /**
     * 商户号
     * custId，mercId二选一，若都传则以商户号为准
     */
    private String mercId;
    
    /**
     * 客户号
     * custId，mercId二选一，若都传则以商户号为准
     * 字节长度: String(20)
     */
    @Size(max = 20)
    private String custId;
    
    /**
     * 费率信息变更异步通知url
     * 若为空，取资料上送的异步通知url
     */
    private String notifyUrl;
    
    /**
     * 变更申请单类型
     * 1 纸质 2电子 默认1
     * 字节长度: String(2)
     */
    @Size(max = 2)
    private String contractType;
    
    /**
     * 业务方变更申请流水号
     * 唯一 （变更状态查询接口可通过此字段查询）
     * 字节长度: String(32)
     */
    @Size(max = 32)
    private String changeThirdFlowId;
} 