package com.fshows.ysepay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付-对账文件下载请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayUnionaccountDownloadUrlGetRequest extends YsepayBizRequest {

    /**
     * 会计日期
     * 日账单格式为yyyy-MM-dd
     * 字节长度: String(10)
     * 必填: 是
     * 示例值：2016-04-13
     */
    private String accountDate;

    /**
     * 文件类型
     * 生成文件类型
     * 28：OCF清算文件
     * 29：OCAF交易文件
     * 22：MCF商户对账单文件
     * 36：结算明细文件
     * 字节长度: String(2)
     * 必填: 是
     */
    private String fileType;

    /**
     * 文件压缩类型
     * txt、zip，不上送则默认为txt
     * file_type=22仅支持txt
     * 字节长度: String(3)
     * 必填: 否
     */
    private String compressType;

    /**
     * 收款方商户号
     * 文件类型=22时必填
     * 字节长度: String(20)
     * 必填: 否
     */
    private String sellerId;
} 