package com.fshows.ysepay.request;

import java.math.BigDecimal;

import com.fshows.ysepay.response.YsepayTradeRefundResponse;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付-退款请求参数
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTradeRefundRequest extends YsepayBizRequest {

    private static final long serialVersionUID = 1L;

    /**
     * 商户订单号
     * 商户网站生成的订单号，由商户保证其唯一性，由字母、数字组成。
     * 最大长度：64字节
     * 必填：是
     * 示例值：201908091131532410
     */
    private String outTradeNo;

    /**
     * 交易日期
     * 商户订单号对应的交易日期
     * 最大长度：8字节
     * 必填：是
     * 示例值：20190809
     * 格式：yyyyMMdd
     */
    private String shopdate;

    /**
     * 银盛订单号
     * 银盛支付平台订单号，最短16位，最长32位。
     * 最大长度：32字节
     * 必填：否
     * 示例值：2019080911315324101234
     * 说明：out_trade_no和trade_no至少传一个
     */
    private String tradeNo;

    /**
     * 退款金额
     * 退款金额，该金额不能大于订单金额。
     * 最大长度：16字节
     * 必填：是
     * 示例值：0.01
     * 说明：精确到小数点后两位
     */
    private BigDecimal refundAmount;

    /**
     * 退款原因
     * 退款原因说明。
     * 最大长度：256字节
     * 必填：否
     * 示例值：商品退款
     */
    private String refundReason;

    /**
     * 退款请求号
     * 商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母。
     * 最大长度：64字节
     * 必填：是
     * 示例值：201908091131532410
     * 说明：同一笔交易多次退款需要保证唯一。
     */
    private String outRequestNo;

    /**
     * 商户号
     * 银盛支付分配给商户的商户号。
     * 最大长度：15字节
     * 必填：是
     * 示例值：123456789012345
     */
    private String sellerId;

    /**
     * 商户名称
     * 商户名称
     * 最大长度：128字节
     * 必填：否
     * 示例值：测试商户
     */
    private String sellerName;

    /**
     * 操作员编号
     * 商户操作员编号
     * 最大长度：28字节
     * 必填：否
     * 示例值：OP001
     */
    private String operatorId;

    /**
     * 门店编号
     * 商户门店编号
     * 最大长度：32字节
     * 必填：否
     * 示例值：NJ_001
     */
    private String storeId;

    /**
     * 终端编号
     * 商户机具终端编号
     * 最大长度：32字节
     * 必填：否
     * 示例值：NJ_T_001
     */
    private String terminalId;

    /**
     * 分账标识
     * 分账标识，标识是否分账交易
     * 最大长度：1字节
     * 必填：否
     * 示例值：1
     * 说明：0或空：非分账交易；1：分账交易
     */
    private String divisionFlag;

    /**
     * 平台商户号
     * 平台商户号，若为平台商户，则必填
     * 最大长度：15字节
     * 必填：否
     * 示例值：123456789012345
     */
    private String platformNo;

    /**
     * 子商户号
     * 子商户号，若为平台商户，则必填
     * 最大长度：15字节
     * 必填：否
     * 示例值：123456789012345
     */
    private String subMerchantNo;

} 