package com.fshows.ysepay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付-退款交易查询请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTradeRefundQueryRequest extends YsepayBizRequest {

    /**
     * 商户系统内部订单号
     * 和银盛交易号不能同时为空
     * trade_no,out_trade_no如果同时存在优先取out_trade_no
     * 字节长度: String(1,32)
     * 必填: 是
     */
    private String outTradeNo;

    /**
     * 银盛平台交易流水号
     * trade_no与out_trade_no 不能同时为空
     * 字节长度: String(1,30)
     * 必填: 否
     * 示例值：311160414497667096
     */
    private String tradeNo;

    /**
     * 退款请求订单号
     * 请求退款接口时，传入的退款请求订单号
     * 字节长度: String(1,32)
     * 必填: 是
     * 示例值：RD20120617131075
     */
    private String outRequestNo;
} 