package com.fshows.ysepay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛订单关闭请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTradeCloseRequest extends YsepayBizRequest {

    /**
     * 商户系统内部订单号
     * 字节长度: String(1,32)
     * 必填: 否
     * 示例值: 201805256843192280647118
     */
    private String outTradeNo;

    /**
     * 商户日期(该参数与做交易时一致)
     * 字节长度: String(8,8)
     * 必填: 是
     */
    private String shopdate;

    /**
     * 该交易在银盛支付系统中的交易流水号
     * 商户订单号和银盛交易号不能同时为空
     * 字节长度: String(1,30)
     * 必填: 否
     */
    private String tradeNo;
} 