package com.fshows.ysepay.model.terminal;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import lombok.Data;

/**
 * 终端信息
 */
@Data
public class TerminalInfo {
    
    /**
     * 商户号
     * 必填: 是
     */
    @NotBlank(message = "商户号不能为空")
    private String mercId;

    /**
     * 渠道编号
     * 必填: 是
     */
    @NotBlank(message = "渠道编号不能为空")
    private String channelCode;

    /**
     * 终端操作标识
     * 必填: 是
     */
    @NotBlank(message = "终端操作标识不能为空")
    private String operationType;

    /**
     * 终端类型
     * 必填: 是
     */
    @NotBlank(message = "终端类型不能为空")
    private String terminalType;

    /**
     * 终端编号
     */
    private String terminalNo;

    /**
     * 终端序列号
     */
    private String serialNum;

    /**
     * 终端布放地址
     * 必填: 是
     */
    @NotBlank(message = "终端布放地址不能为空")
    @Size(max = 60, message = "终端布放地址不能超过60个字符")
    private String terminalAddr;

    /**
     * 终端报备状态
     */
    private String terminalReportState;

    /**
     * 终端机具型号
     */
    private String terminalDevcMdl;

    /**
     * 终端定位功能标识
     */
    private String terminalGpsFlg;

    /**
     * 终端报备说明
     */
    private String note;
} 