package com.fshows.ysepay.model.payment;

import lombok.Data;

/**
 * 微信单品优惠活动详情
 */
@Data
public class WxpayPromotionDetail {

    /**
     * 券ID
     * 券或者立减优惠ID
     * 字节长度: String(32)
     * 必填: 是
     * 示例值: 109519
     */
    private String promotionId;

    /**
     * 优惠名称
     * 字节长度: String(64)
     * 必填: 否
     * 示例值: 单品惠-6
     */
    private String name;

    /**
     * 优惠范围
     * GLOBAL- 全场代金券
     * SINGLE- 单品优惠
     * 字节长度: String(32)
     * 必填: 否
     * 示例值: SINGLE
     */
    private String scope;

    /**
     * 优惠类型
     * COUPON- 代金券，需要走结算资金的充值型代金券（境外商户券币种与支付币种一致）
     * DISCOUNT- 优惠券，不走结算资金的免充值型优惠券（境外商户券币种与标价币种一致）
     * 字节长度: String(32)
     * 必填: 否
     * 示例值: DISCOUNT
     */
    private String type;

    /**
     * 用户享受优惠的金额
     * 优惠券面额=微信出资金额+商家出资金额+其他出资方金额
     * 单位：元
     * 字节长度: double
     * 必填: 是
     * 示例值: 5.00
     */
    private Double amount;

    /**
     * 活动ID
     * 在微信商户后台配置的批次ID
     * 字节长度: String(32)
     * 必填: 否
     * 示例值: 931386
     */
    private String activityId;

    /**
     * 微信出资
     * 特指由微信支付商户平台创建的优惠，出资金额等于本项优惠总金额
     * 单位为元
     * 字节长度: String(32)
     * 必填: 否
     * 示例值: 0.00
     */
    private String wxpayContribute;

    /**
     * 商户出资
     * 特指商户自己创建的优惠，出资金额等于本项优惠总金额
     * 单位为元
     * 字节长度: String(32)
     * 必填: 否
     * 示例值: 0.00
     */
    private String merchantContribute;

    /**
     * 其他出资
     * 其他出资方出资金额，单位为元
     * 字节长度: String(32)
     * 必填: 否
     * 示例值: 5.00
     */
    private String otherContribute;
} 