package com.fshows.ysepay.model.payment;

import lombok.Data;

/**
 * 微信优惠信息
 */
@Data
public class WxpayCouponInfo {

    /**
     * 标价币种
     * 默认CNY
     * 字节长度: String(16)
     * 必填: 否
     */
    private String feeType;

    /**
     * 标价金额
     * 订单总金额，单位为元
     * 字节长度: double
     * 必填: 是
     * 示例值: 12.00
     */
    private Double totalFee;

    /**
     * 现金支付币种
     * 默认CNY
     * 字节长度: String(16)
     * 必填: 否
     */
    private String cashFeeType;

    /**
     * 现金支付金额
     * 订单现金支付金额（即客户实际付款金额），单位元
     * 字节长度: double
     * 必填: 是
     * 示例值: 1.01
     */
    private Double cashFee;

    /**
     * 应结订单金额
     * 当订单使用了免充值型优惠券后返回该参数，应结订单金额=订单金额-免充值优惠券金额
     * 单位元
     * 字节长度: double
     * 必填: 否
     */
    private Double settlementTotalFee;

    /**
     * 代金券金额
     * 代金券金额<=订单金额，订单金额-代金券金额=现金支付金额
     * 单位元
     * 字节长度: double
     * 必填: 否
     */
    private Double couponFee;

    /**
     * 附录字段
     * 字节长度: String
     * 必填: 否
     */
    private String ext;

    /**
     * 单品优惠活动
     * 字节长度: String
     * 必填: 是
     */
    private WxpayPromotionDetail promotionDetail;
} 