package com.fshows.ysepay.model.payment;

import java.math.BigDecimal;

import lombok.Data;

/**
 * 微信优惠商品详情
 */
@Data
public class WxpayCouponGoodDetail {

    /**
     * 商户商品编码
     * 由半角的大小写字母、数字、中划线、下划线中的种或几种组成
     * 字节长度: String(32)
     * 必填: 是
     * 示例值: 109519
     */
    private String goodsId;

    /**
     * 商品备注
     * goods_remark 为备注字段，按照配置原样返回，字段内容在微信后台配置券时进行设置
     * 字节长度: String(128)
     * 必填: 否
     * 示例值: 1001
     */
    private String goodsRemark;

    /**
     * 商品优惠金额
     * 单品的总优惠金额，单位为元
     * 字节长度: double
     * 必填: 是
     * 示例值: 1.00
     */
    private BigDecimal discountAmount;

    /**
     * 商品数量
     * 用户购买的数量
     * 字节长度: Int
     * 必填: 是
     * 示例值: 11
     */
    private Integer quantity;

    /**
     * 商品价格
     * 单位为：元
     * 如果商户有优惠，需传输商户优惠后的单价
     * (例如：用户对一笔 100 元的订单使用了商场发的纸质优惠券 100-50，则活动商品的单价应为原单价-50)
     * 字节长度: double
     * 必填: 是
     * 示例值: 5288.00
     */
    private BigDecimal price;

    /**
     * 券或者立减优惠id
     * 关联 promotionDetail.promotion_id
     * 字节长度: String(32)
     * 必填: 是
     * 示例值: 456789
     */
    private String promotionId;
} 