package com.fshows.ysepay.model.income.fee;

import javax.validation.constraints.Size;

import lombok.Data;

/**
 * D0基础费率信息
 */
@Data
public class D0BaseFee {
    
    /**
     * 收费方式
     * 0:按百分比 1:按固定金额
     * 字节长度: String(1)
     * 必填: 否
     */
    @Size(max = 1)
    private String rateType;

    /**
     * 费率
     * 按百分比时单位为% 按固定金额时 单位为分
     * 字节长度: String(16)
     * 必填: 否
     */
    @Size(max = 16)
    private String rateFee;

    /**
     * 最低收费
     * 单位为分 按百分比时生效
     * 字节长度: String(16)
     * 必填: 否
     */
    @Size(max = 16)
    private String rateBottom;

    /**
     * 最高收费
     * 单位为分 按百分比时生效
     * 字节长度: String(16)
     * 必填: 否
     */
    @Size(max = 16)
    private String rateTop;
} 