package com.fshows.ysepay.model.income.fee;

import lombok.Data;

/**
 * 扫码工作日到账费率
 */
@Data
public class CodeScanT1Fee {
    
    /**
     * 微信扫码费率
     */
    private BaseFee wxPayFee;
    
    /**
     * 支付宝扫码费率(不区分借贷记)
     */
    private BaseFee aliPayFee;
    
    /**
     * 支付宝扫码借记卡费率
     */
    private BaseFee aliPayDebitFee;
    
    /**
     * 支付宝扫码贷记卡费率
     */
    private BaseFee aliPayCreditFee;
    
    /**
     * 银联一档借记卡扫码费率(>1000)
     */
    private BaseFee bank1debitPayFee;
    
    /**
     * 银联一档贷记卡扫码费率(>1000)
     */
    private BaseFee bank1creditPayFee;
    
    /**
     * 银联二档借记卡扫码费率(<=1000)
     */
    private BaseFee bank2debitPayFee;
    
    /**
     * 银联二档贷记卡扫码费率(<=1000)
     */
    private BaseFee bank2creditPayFee;
} 