package com.fshows.ysepay.model.income.fee;

import javax.validation.constraints.Size;

import lombok.Data;

/**
 * 基础费率信息
 */
@Data
public class BaseFee {
    
    /**
     * 收费方式
     * 只支持0按百分比
     * 字节长度: String(1)
     * 必填: 否
     */
    @Size(max = 1)
    private String rateType;

    /**
     * 费率
     * 单位为% 填0.53代表0.53%
     * 字节长度: String(16)
     * 必填: 否
     */
    @Size(max = 16)
    private String rateFee;

    /**
     * 最低收费
     * 单位为分
     * 字节长度: String(16)
     * 必填: 否
     */
    @Size(max = 16)
    private String rateBottom;

    /**
     * 最高收费
     * 单位为分
     * 字节长度: String(16)
     * 必填: 否
     */
    @Size(max = 16)
    private String rateTop;
} 