package com.fshows.ysepay.model.income;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 营业信息
 * @author mengqf
 */
@Data
public class UpdateBusInfo {

    /**
     * 营业执照名称/商户名称
     * 字节长度: String(50)
     */
    @Size(max = 50)
    private String busNm;

    /**
     * 营业执照有效期
     * 非小微必填 格式为yyyyMMdd
     * 字节长度: String(8)
     * 必填: 否
     */
    @Size(min = 8, max = 8)
    private String busCertExpire;

    /**
     * 营业详细地址
     * 需包含省市区
     * 字节长度: String
     */
    private String busAddr;

    /**
     * 注册地址
     * 默认营业地址一致
     * 字节长度: String
     * 必填: 否
     */
    private String regAddr;
} 