package com.fshows.ysepay.model.income;

import java.util.List;

import com.fshows.ysepay.model.income.fee.CodeScanT1Fee;
import com.fshows.ysepay.model.income.fee.D0BaseFee;
import com.fshows.ysepay.model.income.fee.OutCardFee;
import com.fshows.ysepay.model.income.fee.SwCardD0Fee;
import com.fshows.ysepay.model.income.fee.SwCardT1Fee;

import lombok.Data;

/**
 * 商户费率信息
 */
@Data
public class FeeInfo {
    
    /**
     * 扫码工作日到账费率
     */
    private CodeScanT1Fee codeScanT1Fee;
    
    /**
     * 扫码实时到账垫资费
     * busOpenType=01时必填
     */
    private D0BaseFee codeScanD0Fee;
    
    /**
     * 刷卡工作日到账费率
     */
    private SwCardT1Fee swCardT1Fee;
    
    /**
     * 刷卡实时到账垫资费
     */
    private SwCardD0Fee swCardD0Fee;
    
    /**
     * 天天到账垫资费
     */
    private D0BaseFee d1Fee;
    
    /**
     * 外卡费率
     * T+2到账费率(境外卡)
     * busOpenType=21时必填
     * 连通境外卡为T+1到账
     */
    private List<OutCardFee> outCardFeeList;
} 