package com.fshows.ysepay.model.income;

import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import lombok.Data;

/**
 * 法人信息
 */
@Data
public class CrpInfo {
	
	/**
	 * 法人证件号
	 * 字节长度: String(30)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 30)
	private String crpCertNo;
	
	/**
	 * 法人证件类型
	 * 00：身份证 06：国外护照 07：港澳通行证 08：台胞通行证
	 * 字节长度: String(2)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 2)
	private String crpCertType;
	
	/**
	 * 证件开始日期
	 * 格式yyyyMMdd
	 * 字节长度: String(8)
	 * 必填: 是
	 */
	@NotBlank
	@Size(min = 8, max = 8)
	private String certBgn;
	
	/**
	 * 证件有效期
	 * 格式yyyyMMdd，如果为长期或者永久，请填值"29991231"
	 * 字节长度: String(8)
	 * 必填: 是
	 */
	@NotBlank
	@Size(min = 8, max = 8)
	private String certExpire;
	
	/**
	 * 法人国籍
	 * 默认中国(249)
	 * 字节长度: String(3)
	 * 必填: 否
	 */
	@Size(max = 3)
	private String crpNati;
	
	/**
	 * 法人姓名
	 * 字节长度: String(20)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 20)
	private String crpNm;
	
	/**
	 * 法人手机号
	 * 字节长度: String(11)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 11)
	private String crpPhone;
	
	/**
	 * 法人地址
	 * 字节长度: String(100)
	 * 必填: 否
	 */
	@Size(max = 100)
	private String crpAddr;
	
	/**
	 * 实际控制人
	 * 默认同法人信息
	 * 必填: 否
	 */
	private ActContrInfo actContrInfo;
	
	/**
	 * 被授权人信息
	 * 法人结算同法人信息,非法人结算同开户人信息
	 * 必填: 否
	 */
	private AuthInfo authInfo;
	
	/**
	 * 受益人
	 * 默认同法人，最多三个受益人
	 * 必填: 否
	 */
	private List<BnfInfo> bnfList;
}