package com.fshows.ysepay;

import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import lombok.Data;

/**
 * 银盛支付配置模型
 */
@Data
public class YsepayIncomeClientConfigModel extends DefaultClientConfigModel {

    /**
     * 用于加签的商户私钥证书路径
     */
    private String privateKeyPath;

    /**
     * 用于验签的银盛公钥证书路径
     */
    private String ysepayPublicKeyPath;

    /**
     * 商户号
     */
    private String certId;

    /**
     * 业务代码
     */
    private String businessCode;

    /**
     * 签名类型 RSA/SM
     */
    private String signType = "RSA";

    /**
     * 字符集
     */
    private String charset = "UTF-8";
    
} 