package com.fshows.ysepay.request.income;

import javax.validation.constraints.Size;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户进件状态查询请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayQueryCustChangeRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -6257247239248402532L;

    /**
     * 变更申请流水
     * 字节长度: String(21)
     */
    @Size(max = 21)
    private String changeSysFlowId;

    /**
     * 业务方变更申请流水号
     * 若信息变更申请接口有上送此字段，则可通过此字段查询商户变更申请信息
     * 字节长度: String(32)
     */
    @Size(max = 32)
    private String changeThirdFlowId;
    
} 