package com.fshows.ysepay.model.payment;

import java.util.List;

import lombok.Data;

/**
 * 支付宝优惠券信息
 */
@Data
public class AlipayVoucherDetail {

    /**
     * 券id
     * 字节长度: String
     * 必填: 是
     */
    private String id;

    /**
     * 券名称
     * 字节长度: String
     * 必填: 是
     */
    private String name;

    /**
     * 券类型
     * 字节长度: String
     * 必填: 是
     * 示例值: ALIPAY_FIX_VOUCHER
     */
    private String typeStr;

    /**
     * 优惠券面值
     * 字节长度: double
     * 必填: 是
     */
    private Double amount;

    /**
     * 商家出资
     * 字节长度: double
     * 必填: 否
     */
    private Double merchantContribute;

    /**
     * 其他出资方出资金额
     * 字节长度: double
     * 必填: 否
     */
    private Double otherContribute;

    /**
     * 优惠券备注信息
     * 字节长度: String
     * 必填: 否
     */
    private String memo;

    /**
     * 卷模板id
     * 字节长度: String
     * 必填: 否
     * 示例值: 20171030000730015359000EMZP0
     */
    private String templateId;

    /**
     * 优惠券的其他出资方明细
     * 字节长度: List
     * 必填: 否
     */
    private List<Object> otherContributeDetail;

    /**
     * 买家出资
     * 字节长度: double
     * 必填: 否
     */
    private Double purchaseBuyerContribute;

    /**
     * 商家出资
     * 字节长度: double
     * 必填: 否
     */
    private Double purchaseMerchantContribute;

    /**
     * 平台出资
     * 字节长度: double
     * 必填: 否
     */
    private Double purchaseAntContribute;
} 