package com.fshows.ysepay.model.income;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import lombok.Data;

/**
 * 文件元信息
 */
@Data
public class FileMeta {

    /**
     * 图片类别
     * 字节长度: String(4)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 5)
    private String picType;

    /**
     * 文件名
     * 字节长度: String(50)
     * 必填: 否
     */
    @Size(max = 50)
    private String picNm;

    /**
     * 入网申请流水号
     * 字节长度: String(25)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 25)
    private String sysFlowId;

    /**
     * 文件摘要
     * 图片文件的SHA256值
     * 必填: 是
     */
    @NotBlank
    private String sha256;
} 