package com.fshows.ysepay.constant;

/**
 * 报备相关常量
 */
public class ReportConstant {
    
    /**
     * 交易报备渠道编号
     */
    public static class ChannelId {
        /** 银联微信 */
        public static final String CUPS_WECHAT = "CUPS_WECHAT";
        /** 银联支付宝 */
        public static final String CUPS_ALIPAY = "CUPS_ALIPAY";
        /** 网联微信 */
        public static final String NUCC_WECHAT = "NUCC_WECHAT";
        /** 网联支付宝 */
        public static final String NUCC_ALIPAY = "NUCC_ALIPAY";
    }

    /**
     * 商户类别
     */
    public static class MerchantType {
        /** 普通商户 */
        public static final String NORMAL = "0";
        /** 小微商户 */
        public static final String MICRO = "1";
        /** 个体商户 */
        public static final String INDIVIDUAL = "2";
        /** 事业单位 */
        public static final String INSTITUTION = "3";
        /** 社会组织 */
        public static final String SOCIAL = "4";
        /** 政府机关 */
        public static final String GOVERNMENT = "5";
    }

    /**
     * 报备状态
     */
    public static class ReportStatus {
        /** 已注册（交易开通） */
        public static final String REGISTERED = "00";
        /** 待审核 */
        public static final String PENDING = "01";
        /** 审核中 */
        public static final String REVIEWING = "02";
        /** 注册失败 */
        public static final String FAILED = "03";
        /** 交易关闭 */
        public static final String CLOSED = "04";
    }
} 