/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ysepay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.FromHttpRequestHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.ysepay.YsepayClientConfigModel;
import com.fshows.ysepay.apienum.YsepayTradeApiDefinitionEnum;
import com.fshows.ysepay.request.YsepayBizRequest;
import com.fshows.ysepay.response.YsepayBaseResponse;
import com.fshows.ysepay.util.YsepaySignatureUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YsepayApiClient
extends AbstractApiClient<YsepayBizRequest, YsepayBaseResponse, YsepayTradeApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(YsepayApiClient.class);
    private PublicKey publicKey;
    private PrivateKey privateKey;
    protected IHttpRequestHandler httpRequestHandler = new FromHttpRequestHandler();

    public YsepayApiClient(YsepayClientConfigModel apiClientConfig) throws Exception {
        super((DefaultClientConfigModel)apiClientConfig);
        this.publicKey = YsepaySignatureUtil.getPublicKeyFromCert(apiClientConfig.getYsepayPublicKeyPath());
        this.privateKey = YsepaySignatureUtil.getPrivateKey(apiClientConfig.getPrivateKeyPath());
    }

    public YsepayBaseResponse execute(YsepayBizRequest request, YsepayTradeApiDefinitionEnum apiDefinition) throws FsApiException {
        return (YsepayBaseResponse)this.doExecute(request, apiDefinition);
    }

    public YsepayBaseResponse execute(YsepayBizRequest request, YsepayTradeApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected YsepayBaseResponse doExecute(YsepayBizRequest request, YsepayTradeApiDefinitionEnum iApiDefinition, DefaultClientConfigModel customConfig) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, customConfig);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            LogUtil.debug((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u5bc6\u6587] >> url={}, method={}, request={}, response={}, cost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, apiRequestModel.getRequestBody(), apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            YsepayBaseResponse response = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, totalcost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)apiRequestModel.getRequest()), JSONObject.toJSONString((Object)response), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            return response;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u4e1a\u52a1\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38[\u660e\u6587] >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected DefaultRequestContext buildRequestContext(YsepayTradeApiDefinitionEnum tradeApiDefinitionEnum, YsepayBizRequest request, DefaultClientConfigModel customConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        YsepayClientConfigModel clientConfig = (YsepayClientConfigModel)this.apiClientConfig;
        YsepayClientConfigModel config = new YsepayClientConfigModel();
        config.setPartnerId(StringUtils.isEmpty((CharSequence)request.getPartnerId()) ? clientConfig.getPartnerId() : request.getPartnerId());
        config.setNotifyUrl(request.getNotifyUrl());
        config.setApiParentURL(clientConfig.getApiParentURL());
        config.setCharset(clientConfig.getCharset());
        config.setSignType(clientConfig.getSignType());
        config.setVersion(tradeApiDefinitionEnum.getVersion());
        config.setPrivateKeyPath(clientConfig.getPrivateKeyPath());
        config.setYsepayPublicKeyPath(clientConfig.getYsepayPublicKeyPath());
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    protected ApiRequestModel buildApiRequestModel(YsepayBizRequest request, DefaultRequestContext context) {
        YsepayClientConfigModel configModel = (YsepayClientConfigModel)context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL());
        apiRequestModel.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("method", context.getIApiDefinition().getApiURI());
        formParams.put("partner_id", configModel.getPartnerId());
        formParams.put("timestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        formParams.put("charset", configModel.getCharset());
        formParams.put("sign_type", configModel.getSignType());
        if (StringUtils.isNotBlank((CharSequence)configModel.getNotifyUrl())) {
            formParams.put("notify_url", configModel.getNotifyUrl());
        }
        formParams.put("version", configModel.getVersion());
        SerializeConfig config = new SerializeConfig();
        config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        String bizContent = JSON.toJSONString((Object)request, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
        formParams.put("biz_content", bizContent);
        try {
            String sign = YsepaySignatureUtil.sign(formParams, this.privateKey);
            formParams.put("sign", sign);
        }
        catch (FsApiException e) {
            throw new FsApiException("\u751f\u6210\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
        apiRequestModel.setRequestForm(formParams);
        apiRequestModel.setRequest((IRequestDefinition)request);
        return apiRequestModel;
    }

    private Map<String, Object> buildBizParams(YsepayBizRequest request) {
        Field[] fields;
        HashMap<String, Object> bizParams = new HashMap<String, Object>();
        for (Field field : fields = request.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(request);
                if (value == null || "serialVersionUID".equals(field.getName())) continue;
                String paramName = this.camelToUnderline(field.getName());
                bizParams.put(paramName, value);
            }
            catch (IllegalAccessException e) {
                log.error("\u6784\u5efa\u4e1a\u52a1\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            }
        }
        return bizParams;
    }

    private String camelToUnderline(String camelStr) {
        if (StringUtils.isEmpty((CharSequence)camelStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelStr.length(); ++i) {
            char c = camelStr.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append("_");
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u94f6\u76db\u652f\u4ed8");
        clientInfoModel.setClientCode("ysepay-sdk");
        return clientInfoModel;
    }

    protected YsepayBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        try {
            JsonParser parser = new JsonParser();
            String responseKey = requestContext.getIApiDefinition().getApiURI().replace(".", "_") + "_response";
            JsonObject jsonObject = parser.parse(apiResponseModel.getResponseBody()).getAsJsonObject();
            LogUtil.info((Logger)log, (String)"ysepay response jsonObject:{}, responseKey:{}", (Object[])new Object[]{jsonObject, responseKey});
            String content = jsonObject.get(responseKey).toString();
            String sign = jsonObject.get("sign").toString();
            sign = sign.substring(1, sign.length() - 1);
            YsepayClientConfigModel configModel = (YsepayClientConfigModel)requestContext.getApiClientConfig();
            try {
                boolean verifyResult = YsepaySignatureUtil.verifyResponse(content, sign, this.publicKey);
                if (!verifyResult) {
                    throw new FsApiException("\u94f6\u76db\u54cd\u5e94\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25, sign=" + sign);
                }
            }
            catch (FsApiException e) {
                throw new FsApiException("\u94f6\u76db\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            }
            YsepayBaseResponse baseResponse = (YsepayBaseResponse)JSONObject.parseObject((String)content, YsepayBaseResponse.class);
            IResponseDefinition iResponseDefinition = (IResponseDefinition)JSON.parseObject((String)content, (Class)requestContext.getIApiDefinition().getResponseClass());
            baseResponse.setDecryptBusinessContext(iResponseDefinition);
            baseResponse.removeErrorCharFromMsg();
            return baseResponse;
        }
        catch (Exception e) {
            throw new FsApiException("\u89e3\u6790\u54cd\u5e94\u5931\u8d25", (Throwable)e);
        }
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }
}

