package com.fshows.ysepay.model.income;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 商户基本信息
 */
@Data
public class CustInfo {
    
    /**
     * 代理商编号
     * 字节长度: String(15)
     * 必填: 否
     */
    @Size(max = 15)
    private String agtMercId;

    /**
     * 商户名称
     * 字节长度: String(100)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 100)
    private String mercName;

    /**
     * 商户简称
     * 字节长度: String(20)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 20)
    private String mercShortName;

    /**
     * 商户类型
     * 2:小微 3:个体 4:企业 5:社会组织 6:事业单位 7:政府机关
     * 字节长度: String(2)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 2)
    private String mercType;

    /**
     * mcc码
     * 字节长度: String(4)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 4)
    private String mccCd;

    /**
     * 联系人邮箱
     * 字节长度: String(50)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 50)
    private String contactMail;

    /**
     * 联系人
     * 默认同法人
     * 字节长度: String(20)
     * 必填: 否
     */
    @Size(max = 20)
    private String contactMan;

    /**
     * 联系人电话
     * 默认同法人电话号码
     * 字节长度: String(11)
     * 必填: 否
     */
    @Size(max = 11)
    private String contactPhone;

    /**
     * 客户经理
     * 字节长度: String(20)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 20)
    private String cusMgrNm;

    /**
     * 是否开通营销
     * Y开通N不开通,默认不开通
     * 字节长度: String(1)
     * 必填: 否
     */
    @Size(max = 1)
    private String isOpenMarket;

    /**
     * 异步通知地址
     * 字节长度: String(100)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 100)
    private String notifyUrl;

    /**
     * 备注
     * 字节长度: String(200)
     * 必填: 否
     */
    @Size(max = 200)
    private String remark;

    /**
     * 智慧场景
     * 字节长度: String(10)
     * 必填: 否
     */
    @Size(max = 10)
    private String smartScene;
} 