package com.fshows.ysepay.response.income;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

/**
 * 商户资料审核响应对象
 */
@Data
public class YsepayIncomeAuditCustInfoApplyResponse implements IResponseDefinition {
    
    private static final long serialVersionUID = -3073206736671749597L;
    /**
     * 客户号
     * 入网成功后返回
     * 字节长度: String(20)
     * 必填: 否
     */
    private String custId;

    /**
     * 入网申请流水号
     * 字节长度: String(25)
     * 必填: 否
     */
    private String sysFlowId;

    /**
     * 入网状态
     * 00:入网成功
     * 01:待上传图片
     * 02:待审核
     * 90:审核拒绝
     * 10:转人工审核
     * 字节长度: String(2)
     * 必填: 否
     */
    private String status;
} 