package com.fshows.ysepay.model.income;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import lombok.Data;

/**
 * 变更资料图片元信息
 */
@Data
public class ChangePicMeta {

    /**
     * 变更申请流水号
     * 字节长度: String(21)
     * 必填: 是
     */
    @NotBlank(message = "变更申请流水号不能为空")
    @Size(max = 21)
    private String changeFlowId;

    /**
     * 图片类别
     * A001-营业执照 A002-法人身份证正面 A003-法人身份证反面 等
     * 字节长度: String(4)
     * 必填: 是
     */
    @NotBlank(message = "图片类别不能为空")
    @Size(max = 5)
    private String picType;

    /**
     * 文件名
     * 字节长度: String(50)
     * 必填: 是
     */
    @Size(max = 50)
    private String picNm;

    /**
     * 文件摘要
     * 图片文件的SHA256值
     * 字节长度: String(200)
     * 必填: 是
     */
    @NotBlank(message = "文件摘要不能为空")
    @Size(max = 200)
    private String sha256;
} 