package com.fshows.ysepay.model.income.fee;

import javax.validation.constraints.NotBlank;

import lombok.Data;

/**
 * 境外卡费率
 */
@Data
public class OutCardFee {
    
    /**
     * 费率类型
     * 1:VISA DCC 2:VISA EDC 3:万事达 DCC 4:万事达 EDC
     * 6:大莱 EDC 9:JCB DCC 10:JCB EDC 11:连通境外卡
     * 13:银联外卡借记卡费率 14:银联外卡贷记卡费率
     * 必填: 是
     */
    @NotBlank
    private String feeType;

    /**
     * 费率
     * 按百分比计费。如:费率为0.01%，填0.01
     * 必填: 是
     */
    @NotBlank
    private String rateFee;

    /**
     * 最低收费
     * 单位分
     * 必填: 是
     */
    @NotBlank
    private String rateBottom;

    /**
     * 收费方式
     * 只支持0按百分比
     * 必填: 是
     */
    @NotBlank
    private String rateType;
} 