package com.fshows.ysepay.response;

import java.math.BigDecimal;
import java.util.List;

import com.fshows.ysepay.model.payment.WxpayCouponGoodDetail;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付扫码支付响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayBarcodePayResponse extends YsepayBizResponse {

    /**
     * 商户系统生成的订单号
     * 字节长度: String(32)
     * 必填: 是
     * 示例值: 6843192280647118
     */
    private String outTradeNo;

    /**
     * 银盛支付交易流水号
     * 字节长度: String(30)
     * 必填: 否
     */
    private String tradeNo;

    /**
     * 交易状态
     * 成功状态的值为: TRADE_SUCCESS
     * 字节长度: String
     * 必填: 是
     */
    private String tradeStatus;

    /**
     * 交易扩展状态
     * 支付中可参考此状态
     * 字节长度: String
     * 必填: 否
     */
    private String tradeStatusExt;

    /**
     * 订单金额
     * 该笔订单的资金总额，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 是
     * 示例值: 100
     */
    private BigDecimal totalAmount;

    /**
     * 银盛入账日期
     * 格式"yyyy-MM-dd"
     * 字节长度: String(19)
     * 必填: 否
     * 示例值: 2017-05-01
     */
    private String accountDate;

    /**
     * 子商户appid下用户唯一标识
     * 字节长度: String(128)
     * 必填: 否
     */
    private String openid;
    

    /**
     * 银联优惠信息
     * 优惠信息活动对象为多个时，coupon_Info中就有多方优惠信息
     * spnsrId出资方，值为1时银联出资，值为2时付款方出资，值为3时商户出资offstAmt
     * 字节长度: String(100)
     * 必填: 否
     */
    private String couponInfo;

    /**
     * 结算金额
     * 字节长度: Number(10,2)
     * 必填: 否
     * 示例值: 100
     */
    private BigDecimal settlementAmount;

    /**
     * 是否参与优惠
     * Y/N
     * 字节长度: String
     * 必填: 否
     * 示例值: Y
     */
    private String isDiscount;

    /**
     * 总优惠手续费
     * 字节长度: Number(10,2)
     * 必填: 否
     * 示例值: 10.00
     */
    private BigDecimal totalDiscountFee;

    /**
     * 总优惠金额
     * 字节长度: Number(10,2)
     * 必填: 否
     * 示例值: 100.00
     */
    private BigDecimal totalDiscount;

    /**
     * 商户自定义数据域
     * 字节长度: String(2000)
     * 必填: 否
     */
    private String extraCommonParam;

    /**
     * 微信营销信息
     * 详细信息是一个json串，交易成功时返回
     * 字节长度: String
     * 必填: 否
     */
    private String wxpayCouponInfo;

    /**
     * 微信营销活动单品列表
     * 必填: 否
     */
    private List<WxpayCouponGoodDetail> wxpayCouponGoodDetail;

    /**
     * 支付宝营销渠道响应优惠信息
     * JSON字符串
     * 字节长度: String(4000)
     * 必填: 否
     */
    private String alipayCouponInfo;

    /**
     * 支付宝营销渠道响应商品详情信息
     * JSON字符串
     * 字节长度: String(4096)
     * 必填: 否
     */
    private String alipayCouponGoodDetail;

    /**
     * 支付完成时间
     * 格式"yyyy-MM-dd HH:mm:ss"
     * 字节长度: String(19)
     * 必填: 否
     * 示例值: 2014-07-24 03:07:50
     */
    private String paySuccessTime;

    /**
     * 支付宝用户Uid
     * 字节长度: String(128)
     * 必填: 否
     */
    private String buyerUserId;

    /**
     * 卡类型
     * credit:信用卡
     * debit:借记卡
     * 字节长度: String
     * 必填: 否
     * 示例值: credit
     */
    private String cardType;

    /**
     * 风险信息
     * json串
     * 字节长度: String
     * 必填: 否
     */
    private String riskInfo;

    /**
     * 优惠金额
     * 字节长度: Number(10,2)
     * 必填: 否
     */
    private BigDecimal preferentialAmount;

    /**
     * 优惠手续费
     * 字节长度: Number(10,2)
     * 必填: 否
     */
    private BigDecimal preferentialFee;

    /**
     * 营销规则
     * json
     * 字节长度: String
     * 必填: 否
     */
    private String marketingRuleJson;

    /**
     * 发往渠道流水号
     * 字节长度: String(50)
     * 必填: 否
     */
    private String channelSendSn;

    /**
     * 渠道返回流水号
     * 字节长度: String(50)
     * 必填: 否
     */
    private String channelRecvSn;
    
} 