package com.fshows.ysepay.request.income;

import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import com.fshows.ysepay.model.income.fee.BaseFee;
import com.fshows.ysepay.model.income.fee.CodeScanT1Fee;
import com.fshows.ysepay.model.income.fee.OutCardFee;

import com.fshows.ysepay.model.income.fee.SwCardD0Fee;
import com.fshows.ysepay.model.income.fee.SwCardT1Fee;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户签约请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayIncomeSignRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -8030656687185023162L;
    /**
     * 到账方式
     * 00-扫码工作日到账 01-扫码实时到账 10-刷卡工作日到账
     * 11-刷卡实时到账 20-D1到账 21-境外卡到账
     * 允许多选用"|"分隔 T1工作日到账必选
     * 字节长度: String(100)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 100)
    private String busOpenType;

    /**
     * 合同类型
     * 1-纸质合同、2-电子合同
     * 字节长度: String(1)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 1)
    private String contractType;

    /**
     * 是否自动发送签约通知
     * contractType=2时必填
     * 0(短信+邮件) 1(短信) 2(邮件) 3(不通知)
     * 字节长度: String(1)
     * 必填: 否
     */
    @Size(max = 1)
    private String isSendConMsg;

    /**
     * 异步通知地址
     * 字节长度: String(100)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 100)
    private String notifyUrl;

    /**
     * 客户号
     * 字节长度: String(20)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 20)
    private String custId;

    /**
     * 业务方权限id
     * 字节长度: String(32)
     * 必填: 否
     */
    @Size(max = 32)
    private String thirdAuthId;

    /**
     * 扫码工作日到账费率
     */
    private CodeScanT1Fee codeScanT1Fee;

    /**
     * 扫码实时到账垫资费
     */
    private BaseFee codeScanD0Fee;

    /**
     * 刷卡工作日到账费率
     */
    private SwCardT1Fee swCardT1Fee;

    /**
     * 刷卡实时到账垫资费
     */
    private SwCardD0Fee swCardD0Fee;

    /**
     * 天天到账垫资费
     */
    private BaseFee d1Fee;

    /**
     * 境外卡费率列表
     */
    private List<OutCardFee> outCardFeeList;
} 