package com.fshows.ysepay.model.income;

import lombok.Data;

import javax.validation.constraints.Size;

/**
 * 商户基本信息
 * @author mengqf
 */
@Data
public class UpdateCustInfo {

    /**
     * 商户名称
     * 字节长度: String(100)
     * 必填: 是
     */
    @Size(max = 100)
    private String mercName;

    /**
     * 商户简称
     * 字节长度: String(20)
     */
    @Size(max = 20)
    private String mercShortName;

    /**
     * 联系人邮箱
     * 字节长度: String(50)
     */
    @Size(max = 50)
    private String contactMail;

    /**
     * 联系人
     * 默认同法人
     * 字节长度: String(20)
     * 必填: 否
     */
    @Size(max = 20)
    private String contactMan;

    /**
     * 联系人电话
     * 默认同法人电话号码
     * 字节长度: String(11)
     * 必填: 否
     */
    @Size(max = 11)
    private String contactPhone;
} 