package com.fshows.ysepay.response;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银联行业码获取用户标识响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayCupgetmulappUseridResponse extends YsepayBizResponse {

    /**
     * 响应代码
     * 字节长度: String
     * 必填: 是
     */
    private String code;

    /**
     * 响应代码描述
     * 字节长度: String
     * 必填: 是
     */
    private String msg;

    /**
     * 交易状态
     * SUCCES：获取成功
     * FAILED：获取失败
     * 字节长度: String(30)
     * 必填: 是
     */
    private String tradeStatus;

    /**
     * 返回信息
     * 字节长度: String(50)
     * 必填: 否
     */
    private String subMsg;

    /**
     * 用户标识
     * 字节长度: String(128)
     * 必填: 否
     */
    private String userId;
} 