package com.fshows.ysepay.apienum;

import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.ysepay.request.income.YsepayChangeMercInfoRequest;
import com.fshows.ysepay.request.income.YsepayChangeMercStlAccInfoRequest;
import com.fshows.ysepay.request.income.YsepayChangeRateRequest;
import com.fshows.ysepay.request.income.YsepayIncomeAddCustInfoApplyRequest;
import com.fshows.ysepay.request.income.YsepayIncomeAuditCustInfoApplyRequest;
import com.fshows.ysepay.request.income.YsepayIncomeFileUploadRequest;
import com.fshows.ysepay.request.income.YsepayIncomeModifyCustInfoApplyRequest;
import com.fshows.ysepay.request.income.YsepayIncomeQueryAuthInfoRequest;
import com.fshows.ysepay.request.income.YsepayIncomeQueryCustApplyRequest;
import com.fshows.ysepay.request.income.YsepayIncomeSignRequest;
import com.fshows.ysepay.request.income.YsepayIncomeSignSendMsgRequest;
import com.fshows.ysepay.request.income.YsepayQueryCustChangeRequest;
import com.fshows.ysepay.request.income.YsepayUploadChangePicRequest;
import com.fshows.ysepay.request.report.YsepayAppidAddOrUpdateRequest;
import com.fshows.ysepay.request.report.YsepayAuthPathAddRequest;
import com.fshows.ysepay.request.report.YsepayReportQueryInfoRequest;
import com.fshows.ysepay.request.terminal.YsepayTerminalReportRequest;
import com.fshows.ysepay.request.terminal.YsepayTerminalReportSearchRequest;
import com.fshows.ysepay.response.income.YsepayChangeMercInfoResponse;
import com.fshows.ysepay.response.income.YsepayChangeMercStlAccInfoResponse;
import com.fshows.ysepay.response.income.YsepayChangeRateResponse;
import com.fshows.ysepay.response.income.YsepayIncomeAddCustInfoApplyResponse;
import com.fshows.ysepay.response.income.YsepayIncomeAuditCustInfoApplyResponse;
import com.fshows.ysepay.response.income.YsepayIncomeFileUploadResponse;
import com.fshows.ysepay.response.income.YsepayIncomeModifyCustInfoApplyResponse;
import com.fshows.ysepay.response.income.YsepayIncomeQueryAuthInfoResponse;
import com.fshows.ysepay.response.income.YsepayIncomeQueryCustApplyResponse;
import com.fshows.ysepay.response.income.YsepayIncomeSignResponse;
import com.fshows.ysepay.response.income.YsepayIncomeSignSendMsgResponse;
import com.fshows.ysepay.response.income.YsepayQueryCustChangeResponse;
import com.fshows.ysepay.response.income.YsepayUploadChangePicResponse;
import com.fshows.ysepay.response.report.YsepayAppidAddOrUpdateResponse;
import com.fshows.ysepay.response.report.YsepayAuthPathAddResponse;
import com.fshows.ysepay.response.report.YsepayReportQueryInfoResponse;
import com.fshows.ysepay.response.terminal.YsepayTerminalReportResponse;
import com.fshows.ysepay.response.terminal.YsepayTerminalReportSearchResponse;

import lombok.Getter;

/**
 * 银盛支付API定义枚举
 */
@Getter
public enum YsepayIncomeApiDefinitionEnum implements IApiDefinition {
	
	/**
	 * 商户状态查询
	 */
    QUERY_CUST_APPLY(
			"商户状态查询",
			"/openapi/smsc/queryCustApply",
			"application/json",
			"smsc.queryCustApply",
			"1.1",
			YsepayIncomeQueryCustApplyRequest.class,
			YsepayIncomeQueryCustApplyResponse.class),
	
	/**
	 * 商户进件
	 */
	ADD_CUST_INFO_APPLY(
		"商户进件",
		"/openapi/smsc/addCustInfoApply",
			"application/json",
			"t1.smsc.addCustInfoApply",
			"1.3",
			YsepayIncomeAddCustInfoApplyRequest.class,
			YsepayIncomeAddCustInfoApplyResponse.class),
	
	/**
	 * 商户资料变更
	 */
	MODIFY_CUST_INFO_APPLY(
		"商户资料变更",
		"/openapi/smsc/modifyCustInfoApply",
			"application/json",
			"smsc.modifyCustInfoApply",
			"1.2",
			YsepayIncomeModifyCustInfoApplyRequest.class,
			YsepayIncomeModifyCustInfoApplyResponse.class),
	
	/**
	 * 商户资料文件上传
	 */
	FILE_UPLOAD(
		"商户资料文件上传",
		"/openapi/file/smsc/upload",
		"multipart/form-data",
		"file.smsc.upload",
		"1.0",
		YsepayIncomeFileUploadRequest.class,
		YsepayIncomeFileUploadResponse.class
	),
	
	/**
	 * 商户资料审核
	 */
	AUDIT_CUST_INFO_APPLY(
		"商户资料审核",
		"/openapi/t1/smsc/auditCustInfoApply",
		"application/json",
		"t1.smsc.auditCustInfoApply",
		"1.0",
		YsepayIncomeAuditCustInfoApplyRequest.class,
		YsepayIncomeAuditCustInfoApplyResponse.class
	),
	
	/**
	 * 商户签约
	 */
	SIGN(
		"商户签约",
		"/openapi/t1/smsc/sign",
		"application/json",
		"t1.smsc.sign",
		"1.5",
		YsepayIncomeSignRequest.class,
		YsepayIncomeSignResponse.class
	),
	
	/**
	 * 签约短信/邮件通知
	 */
	SIGN_SEND_MSG(
		"签约短信/邮件通知",
		"/openapi/smsc/sign/sendSmsOrEmailMsg",
		"application/json",
		"smsc.sign.sendSmsOrEmailMsg",
		"1.0",
		YsepayIncomeSignSendMsgRequest.class,
		YsepayIncomeSignSendMsgResponse.class
	),
	
	/**
	 * 查询授权信息
	 */
	QUERY_AUTH_INFO(
		"查询授权信息",
		"/openapi/smsc/saas/constract/queryAuthInfo",
		"application/json",
		"smsc.saas.constract.queryAuthInfo",
		"1.1",
		YsepayIncomeQueryAuthInfoRequest.class,
		YsepayIncomeQueryAuthInfoResponse.class
	),
	/**
	 * 查询报备信息
	 */
	QUERY_REPORT_INFO(
		"查询报备信息",
		"/openapi/report/scan/union/repAndAppIdQry",
		"application/json",
		"report.scan.union.repAndAppIdQry",
		"1.0",
		YsepayReportQueryInfoRequest.class,
		YsepayReportQueryInfoResponse.class
	),
	
	/**
	 * 终端报备
	 */
	TERMINAL_REPORT(
		"终端报备",
		"/openapi/report/scan/channel/terminalReport",
		"application/json",
		"report.scan.channel.terminalReport",
		"1.0",
		YsepayTerminalReportRequest.class,
		YsepayTerminalReportResponse.class
	),
	
	/**
	 * 终端报备查询
	 */
	TERMINAL_REPORT_SEARCH(
		"终端报备查询",
		"/openapi/report/scan/channel/terminalReportSearch",
		"application/json",
		"report.scan.channel.terminalReportSearch",
		"1.0",
		YsepayTerminalReportSearchRequest.class,
		YsepayTerminalReportSearchResponse.class
	),
	
	/**
	 * 新增/修改appid
	 */
	APPID_ADD_OR_UPDATE(
		"新增/修改appid",
		"/openapi/report/scan/union/appIdAddOrUpdate",
		"application/json",
		"report.scan.union.appIdAddOrUpdate",
		"1.0",
		YsepayAppidAddOrUpdateRequest.class,
		YsepayAppidAddOrUpdateResponse.class
	),
	
	/**
	 * 新增授权目录
	 */
	AUTH_PATH_ADD(
		"新增授权目录",
		"/openapi/report/scan/union/authPathAdd",
		"application/json",
		"report.scan.union.authPathAdd",
		"1.0",
		YsepayAuthPathAddRequest.class,
		YsepayAuthPathAddResponse.class
	),
	
	/**
	 * 商户资料变更
	 */
	CHANGE_MERC_INFO(
		"商户资料变更",
		"/openapi/smsc/saas/merc/changeMercInfo",
		"application/json",
		"smsc.saas.merc.changeMercInfo",
		"1.2",
		YsepayChangeMercInfoRequest.class,
		YsepayChangeMercInfoResponse.class
	),
	
	/**
	 * 变更结算信息
	 */
	CHANGE_MERC_STL_ACC_INFO(
		"变更结算信息",
		"/openapi/t1/smsc/changeMercStlAccInfo",
		"application/json",
		"t1.smsc.changeMercStlAccInfo",
		"1.3",
		YsepayChangeMercStlAccInfoRequest.class,
		YsepayChangeMercStlAccInfoResponse.class
	),
	
	/**
	 * 费率信息变更
	 */
	CHANGE_RATE(
		"费率信息变更",
		"/openapi/smsc/changeRate",
		"application/json",
		"smsc.changeRate",
		"1.6",
		YsepayChangeRateRequest.class,
		YsepayChangeRateResponse.class
	),
	
	/**
	 * 变更资料图片上传
	 */
	UPLOAD_CHANGE_PIC(
		"变更资料图片上传",
		"/openapi/file/smsc/uploadChangePic",
		"multipart/form-data",
		"file.smsc.uploadChangePic",
		"1.0",
		YsepayUploadChangePicRequest.class,
		YsepayUploadChangePicResponse.class
	),
	
	/**
	 * 商户进件状态查询
	 */
	QUERY_CUST_CHANGE(
		"商户进件状态查询",
		"/openapi/smsc/queryCustChange",
		"application/json",
		"smsc.queryCustChange",
		"1.2",
		YsepayQueryCustChangeRequest.class,
		YsepayQueryCustChangeResponse.class
	),
	;
	
	/**
	 * 接口名称
	 */
	private final String name;
	
	/**
	 * 接口URI
	 */
	private final String apiURI;
	
	/**
	 * 接口URI
	 */
	private final String contentType;
	
	private final String method;
	
	/**
	 * 接口版本
	 */
	private final String version;
 
	
	/**
	 * 请求业务参数的Class类型
	 */
	private final Class requestClass;
	
	/**
	 * 响应业务参数的Class类型
	 */
	private final Class responseClass;
	
	YsepayIncomeApiDefinitionEnum(String name,
			String apiURI, String contentType,
			String method,
			String version,
			Class requestClass,
			Class responseClass) {
		this.name = name;
		this.apiURI = apiURI;
		this.contentType = contentType;
		this.method = method;
		this.version = version;
		this.requestClass = requestClass;
		this.responseClass = responseClass;
	}
	
	@Override
	public String getApiURI() {
		return apiURI;
	}
	
	@Override
	public String getVersion() {
		return version;
	}
	
	@Override
	public Class getRequestClass() {
		return requestClass;
	}
	
	@Override
	public Class getResponseClass() {
		return responseClass;
	}
} 