/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ysepay.util;

import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.ysepay.util.CertUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YsepaySignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(YsepaySignatureUtil.class);
    private static final String SIGN_TYPE_RSA = "RSA";
    private static final String SIGN_TYPE_SM = "SM";
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String ALGORITHM_PKCS1PADDING = "RSA/ECB/PKCS1Padding";
    private static final String ALGORITHM = "SHA256withRSA";

    public static String sign(Map<String, String> params, String privateKeyPath) throws FsApiException {
        try {
            String content = YsepaySignatureUtil.getSignContent(params);
            LogUtil.info((Logger)log, (String)("ysepay \u5f85\u7b7e\u540d\u5185\u5bb9: " + content));
            PrivateKey privateKey = YsepaySignatureUtil.getPrivateKey(privateKeyPath);
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            signature.update(content.getBytes(CHARSET_UTF8));
            byte[] signed = signature.sign();
            String sign = Base64.encodeBase64String((byte[])signed);
            LogUtil.info((Logger)log, (String)("ysepay \u7b7e\u540d\u7ed3\u679c: " + sign));
            return sign;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"ysepay RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new FsApiException("RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public static String sign(Map<String, String> params, PrivateKey privateKey) throws FsApiException {
        try {
            String content = YsepaySignatureUtil.getSignContent(params);
            LogUtil.info((Logger)log, (String)("ysepay \u5f85\u7b7e\u540d\u5185\u5bb9: " + content));
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            signature.update(content.getBytes(CHARSET_UTF8));
            byte[] signed = signature.sign();
            String sign = Base64.encodeBase64String((byte[])signed);
            LogUtil.info((Logger)log, (String)("ysepay \u7b7e\u540d\u7ed3\u679c: " + sign));
            return sign;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"ysepay RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new FsApiException("ysepay RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public static String sign(String content, PrivateKey privateKey) throws FsApiException {
        try {
            LogUtil.info((Logger)log, (String)("ysepay \u5f85\u7b7e\u540d\u5185\u5bb9: " + content));
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            signature.update(content.getBytes(CHARSET_UTF8));
            byte[] signed = signature.sign();
            String sign = Base64.encodeBase64String((byte[])signed);
            LogUtil.info((Logger)log, (String)("ysepay \u7b7e\u540d\u7ed3\u679c: " + sign));
            return sign;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"ysepay RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new FsApiException("ysepay RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public static String signWithRsa256(String content, PrivateKey privateKey) throws FsApiException {
        try {
            LogUtil.info((Logger)log, (String)("ysepay \u5f85\u7b7e\u540d\u5185\u5bb9: " + content));
            Signature signature = Signature.getInstance(ALGORITHM);
            signature.initSign(privateKey);
            signature.update(content.getBytes(CHARSET_UTF8));
            byte[] signed = signature.sign();
            String sign = Base64.encodeBase64String((byte[])signed);
            LogUtil.info((Logger)log, (String)("ysepay \u7b7e\u540d\u7ed3\u679c: " + sign));
            return sign;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"ysepay RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new FsApiException("ysepay RSA\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public static boolean verifyResponse(String content, String sign, String publicKeyPath) throws FsApiException {
        try {
            LogUtil.info((Logger)log, (String)("ysepay \u9a8c\u7b7e\u5185\u5bb9\uff1a" + content));
            LogUtil.info((Logger)log, (String)("ysepay \u7b7e\u540d\u503c\uff1a" + sign));
            PublicKey publicKey = YsepaySignatureUtil.getPublicKeyFromCert(publicKeyPath);
            Signature signetcheck = Signature.getInstance(SIGN_ALGORITHMS);
            signetcheck.initVerify(publicKey);
            signetcheck.update(content.getBytes(CHARSET_UTF8));
            LogUtil.info((Logger)log, (String)("ysepay \u516c\u94a5\u7b97\u6cd5\uff1a" + publicKey.getAlgorithm()));
            LogUtil.info((Logger)log, (String)("ysepay \u516c\u94a5\u683c\u5f0f\uff1a" + publicKey.getFormat()));
            return signetcheck.verify(Base64.decodeBase64((byte[])sign.getBytes(CHARSET_UTF8)));
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"ysepay RSA\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
            throw new FsApiException("ysepay RSA\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }

    public static boolean validateSignBySoft(PublicKey publicKey, byte[] signData, byte[] srcData) throws Exception {
        Signature st = Signature.getInstance(ALGORITHM);
        st.initVerify(publicKey);
        st.update(srcData);
        return st.verify(signData);
    }

    public static boolean verifyResponse(String content, String sign, PublicKey publicKey) throws FsApiException {
        try {
            LogUtil.info((Logger)log, (String)("ysepay \u9a8c\u7b7e\u5185\u5bb9\uff1a" + content));
            LogUtil.info((Logger)log, (String)("ysepay \u7b7e\u540d\u503c\uff1a" + sign));
            Signature signetcheck = Signature.getInstance(SIGN_ALGORITHMS);
            signetcheck.initVerify(publicKey);
            signetcheck.update(content.getBytes(CHARSET_UTF8));
            LogUtil.info((Logger)log, (String)("ysepay \u516c\u94a5\u7b97\u6cd5\uff1a" + publicKey.getAlgorithm()));
            LogUtil.info((Logger)log, (String)("ysepay \u516c\u94a5\u683c\u5f0f\uff1a" + publicKey.getFormat()));
            return signetcheck.verify(Base64.decodeBase64((byte[])sign.getBytes(CHARSET_UTF8)));
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"ysepay RSA\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
            throw new FsApiException("ysepay RSA\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }

    public static byte[] encrypt(PublicKey publicKey, byte[] content) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM_PKCS1PADDING);
        cipher.init(1, publicKey);
        return cipher.doFinal(content);
    }

    private static String getSignContent(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        int index = 0;
        for (String key : keys) {
            String value;
            if ("sign".equals(key) || (value = params.get(key)) == null || !StringUtils.isNotBlank((CharSequence)value)) continue;
            content.append(index == 0 ? "" : "&").append(key).append("=").append(value);
            ++index;
        }
        return content.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey getPrivateKey(String privateKeyPath) throws Exception {
        String privateKey = YsepaySignatureUtil.readKey(privateKeyPath);
        try {
            privateKey = privateKey.replaceAll("-----BEGIN PRIVATE KEY-----", "").replaceAll("-----END PRIVATE KEY-----", "").replaceAll("-----BEGIN RSA PRIVATE KEY-----", "").replaceAll("-----END RSA PRIVATE KEY-----", "").replaceAll("\n", "").replaceAll("\r", "").trim();
            byte[] keyBytes = Base64.decodeBase64((String)privateKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(SIGN_TYPE_RSA);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            try (FileInputStream fis = new FileInputStream(privateKeyPath);){
                byte[] keyBytes = new byte[fis.available()];
                fis.read(keyBytes);
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance(SIGN_TYPE_RSA);
                PrivateKey privateKey2 = keyFactory.generatePrivate(keySpec);
                return privateKey2;
            }
            catch (Exception ex) {
                throw new FsApiException("ysepay \u79c1\u94a5\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)ex);
            }
        }
    }

    public static PublicKey getPublicKeyFromCert(String publicKeyPath) throws Exception {
        PublicKey pubKey = null;
        try (FileInputStream ins = new FileInputStream(publicKeyPath);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cac = cf.generateCertificate(ins);
            pubKey = cac.getPublicKey();
        }
        return pubKey;
    }

    public static byte[] encrypt(String crtPath, byte[] content) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM_PKCS1PADDING);
        cipher.init(1, CertUtil.getValidateCert(crtPath).getPublicKey());
        return cipher.doFinal(content);
    }

    private static PublicKey getPublicKey(String publicKeyPath) throws Exception {
        String publicKeyPEM = YsepaySignatureUtil.readKey(publicKeyPath);
        String publicKeyContent = publicKeyPEM.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s+", "");
        byte[] keyBytes = Base64.decodeBase64((String)publicKeyContent);
        KeyFactory keyFactory = KeyFactory.getInstance(SIGN_TYPE_RSA);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        return keyFactory.generatePublic(keySpec);
    }

    private static String readKey(String keyPath) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(keyPath));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String getSignDataStr1(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            if ("sign".equals(key) || "$jacocoData".equals(key)) continue;
            sb.append(key).append("=");
            sb.append(map.get(key));
            sb.append("&");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

