/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ysepay.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;

public class FileUtil {
    public static byte[] readFileToBytes(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static String calculateSHA256(byte[] content) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(content);
        return Hex.encodeHexString((byte[])hash);
    }

    public static boolean isValidImageFormat(String fileName) {
        String ext = fileName.toLowerCase();
        return ext.endsWith(".jpg") || ext.endsWith(".jpeg") || ext.endsWith(".png") || ext.endsWith(".bmp");
    }

    public static boolean isValidFileSize(byte[] content) {
        return content.length <= 0x200000;
    }
}

