/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ysepay.util;

import java.io.ByteArrayOutputStream;

public class ByteUtil {
    private static String hexStr = "0123456789ABCDEF";
    private static final char[] BToA = "0123456789abcdef".toCharArray();
    private static final String N_LINE = "----------------------------------------------------------------------------";
    private static final int DECIMAL = 2;

    public static byte[] int2ByteArray(int iSource, int iArrayLen) {
        byte[] bLocalArr = new byte[iArrayLen];
        for (int i = iArrayLen; i < 4 && i > 0; --i) {
            bLocalArr[i - 1] = (byte)(iSource >> 8 * (iArrayLen - i) & 0xFF);
        }
        return bLocalArr;
    }

    public static String trace(byte[] inBytes) {
        int j = 0;
        byte[] temp = new byte[76];
        ByteUtil.bytesSet(temp, ' ');
        StringBuffer strc = new StringBuffer("");
        strc.append("----------------------------------------------------------------------------\n");
        for (int i = 0; i < inBytes.length; ++i) {
            if (j == 0) {
                System.arraycopy(String.format("%03d: ", i).getBytes(), 0, temp, 0, 5);
                System.arraycopy(String.format(":%03d", i + 15).getBytes(), 0, temp, 72, 4);
            }
            System.arraycopy(String.format("%02X ", inBytes[i]).getBytes(), 0, temp, j * 3 + 5 + (j > 7 ? 1 : 0), 3);
            temp[j + 55 + (j > 7 ? 1 : 0)] = inBytes[i] == 0 ? 46 : inBytes[i];
            if (++j != 16) continue;
            strc.append(new String(temp)).append("\n");
            ByteUtil.bytesSet(temp, ' ');
            j = 0;
        }
        if (j != 0) {
            strc.append(new String(temp)).append("\n");
            ByteUtil.bytesSet(temp, ' ');
        }
        strc.append("----------------------------------------------------------------------------\n");
        return strc.toString();
    }

    private static void bytesSet(byte[] inBytes, char fill) {
        if (inBytes.length == 0) {
            return;
        }
        for (int i = 0; i < inBytes.length; ++i) {
            inBytes[i] = (byte)fill;
        }
    }

    public static byte[] byteAndByte(byte[] begin, byte[] second) {
        int i;
        if (begin == null || begin.length == 0) {
            if (second != null && second.length != 0) {
                return second;
            }
            return null;
        }
        if (second == null || second.length == 0) {
            return begin;
        }
        byte[] newTotal = new byte[begin.length + second.length];
        for (i = 0; i < begin.length; ++i) {
            newTotal[i] = begin[i];
        }
        for (i = begin.length; i < second.length + begin.length; ++i) {
            newTotal[i] = second[i - begin.length];
        }
        return newTotal;
    }

    public static byte[] getsubByte(byte[] total, int begin, int length) {
        if (length > 0) {
            byte[] newTotal = new byte[length];
            for (int i = begin; i < length + begin; ++i) {
                newTotal[i - begin] = total[i];
            }
            return newTotal;
        }
        return new byte[0];
    }

    public static String fillString(String string, char filler, int totalLength, boolean atEnd) {
        byte[] tempbyte = string.getBytes();
        int currentLength = tempbyte.length;
        int delta = totalLength - currentLength;
        for (int i = 0; i < delta; ++i) {
            string = atEnd ? string + filler : filler + string;
        }
        return string;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtil.charToByte(hexChars[pos]) << 4 | ByteUtil.charToByte(hexChars[pos + 1]) & 0xFF);
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static String bytesToString(byte[] src, int begin, int length) {
        String str1 = null;
        StringBuilder sb = new StringBuilder("");
        if (begin == 0 && length == 0) {
            for (byte element : src) {
                sb.append(String.valueOf(element));
            }
        } else {
            for (int i = begin; i < begin + length; ++i) {
                byte element = src[i];
                sb.append(String.valueOf(element));
            }
        }
        str1 = sb.toString();
        return str1;
    }

    public static String binaryToHexString(byte[] bytes) {
        String result = "";
        String hex = "";
        for (int i = 0; i < bytes.length; ++i) {
            hex = String.valueOf(hexStr.charAt((bytes[i] & 0xF0) >> 4));
            hex = hex + String.valueOf(hexStr.charAt(bytes[i] & 0xF));
            result = result + hex;
        }
        return result.toUpperCase();
    }

    public static String binaryToDecimal(String binary) {
        String[] strBinary;
        StringBuffer buf = new StringBuffer();
        for (String str : strBinary = binary.split(" ")) {
            StringBuffer strBuf = new StringBuffer(str);
            char[] element = strBuf.reverse().toString().toCharArray();
            int digit = 0;
            int result = 0;
            for (char temp : element) {
                int intNumber = Integer.parseInt(Character.toString(temp));
                result += (intNumber *= (int)Math.pow(2.0, digit));
                ++digit;
            }
            buf.append(result);
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String toStringHex(String s) {
        byte[] baKeyword = new byte[s.length() / 2];
        for (int i = 0; i < baKeyword.length; ++i) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            s = new String(baKeyword, "utf-8");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static String toStringHex(String s, String charset) {
        byte[] baKeyword = new byte[s.length() / 2];
        for (int i = 0; i < baKeyword.length; ++i) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            s = new String(baKeyword, charset);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static String cbcd2string(byte[] bytes, boolean format, int length) {
        StringBuffer temp = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            temp.append((byte)((bytes[i] & 0xF0) >>> 4));
            temp.append((byte)(bytes[i] & 0xF));
        }
        String val = temp.toString();
        if (format) {
            if (val.length() > length) {
                return val.substring(0, 1).equalsIgnoreCase("0") ? val.substring(1) : val;
            }
            return val;
        }
        if (val.length() > length) {
            return val.substring(val.length() - 1, val.length()).equalsIgnoreCase("0") ? val.substring(0, val.length() - 1) : val;
        }
        return val;
    }

    public static byte[] str2cbcd(String asc, boolean format) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            if (format) {
                asc = "0" + asc;
                len = asc.length();
            } else {
                asc = asc + "0";
                len = asc.length();
            }
        }
        byte[] abt = new byte[len];
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        abt = asc.getBytes();
        for (int p = 0; p < asc.length() / 2; ++p) {
            byte b;
            int j = abt[2 * p] >= 48 && abt[2 * p] <= 57 ? abt[2 * p] - 48 : (abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : abt[2 * p] - 65 + 10);
            int k = abt[2 * p + 1] >= 48 && abt[2 * p + 1] <= 57 ? abt[2 * p + 1] - 48 : (abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : abt[2 * p + 1] - 65 + 10);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
        }
        return bbt;
    }

    public static byte[] str2Bcd(String s, boolean format) {
        if (s.length() % 2 != 0) {
            s = format ? "0" + s : s + "0";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; i += 2) {
            int low;
            int high = cs[i] - 48;
            if (high > 9) {
                high -= 7;
            }
            if ((low = cs[i + 1] - 48) > 9) {
                low -= 7;
            }
            baos.write(high << 4 | low);
        }
        return baos.toByteArray();
    }

    public static String bcd2Str(byte[] b, boolean format, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int h = ((b[i] & 0xFF) >> 4) + 48;
            if (h > 57) {
                h += 7;
            }
            sb.append((char)h);
            int l = (b[i] & 0xF) + 48;
            if (l > 57) {
                l += 7;
            }
            sb.append((char)l);
        }
        String val = sb.toString().toUpperCase();
        if (format) {
            if (val.length() > length) {
                return val.substring(0, 1).equalsIgnoreCase("0") ? val.substring(1) : val;
            }
            return val;
        }
        if (val.length() > length) {
            return val.substring(val.length() - 1, val.length()).equalsIgnoreCase("0") ? val.substring(0, val.length() - 1) : val;
        }
        return val;
    }

    public static String bcd2ASC(byte[] bytes) {
        StringBuffer temp = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int h = (bytes[i] & 0xF0) >>> 4;
            int l = bytes[i] & 0xF;
            temp.append(BToA[h]).append(BToA[l]);
        }
        return temp.toString().toUpperCase();
    }

    public static String toHexString(String s) {
        String str = "";
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            String s4 = Integer.toHexString(ch);
            str = str + s4;
        }
        return str;
    }

    public static byte[] byteTobyte(byte[] data, int index, int lenth) {
        byte[] b = new byte[lenth];
        for (int i = index; i < index + lenth; ++i) {
            b[i - index] = data[i];
        }
        return b;
    }

    public static byte[] replenishByteTo8(byte[] b) {
        int i = b.length;
        int x = i % 8;
        if (x != 0) {
            x = 8 - x;
            String replenish = "";
            for (int j = 0; j < x; ++j) {
                replenish = replenish + "FF";
            }
            return ByteUtil.byteAndByte(b, ByteUtil.hexStringToBytes(replenish));
        }
        return b;
    }

    public static byte[] replenishByteTo16(byte[] b) {
        int i = b.length;
        int x = i % 16;
        if (x != 0) {
            x = 16 - x;
            String replenish = "";
            for (int j = 0; j < x; ++j) {
                replenish = replenish + "FF";
            }
            return ByteUtil.byteAndByte(b, ByteUtil.hexStringToBytes(replenish));
        }
        return b;
    }
}

