package com.fshows.ysepay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;

/**
 * 银联行业码支付请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayCupmulappQrcodePayRequest extends YsepayBizRequest {

    /**
     * 商户系统生成的订单号
     * 须保证在商户端不重复，生成规则前8位必须为交易日期，如20220525
     * 范围跨度支持包含当天在内的前后一天
     * 且只能由大小写英文字母、数字、下划线及横杠组成
     * 字节长度: String(1,32)
     * 必填: 是
     * 示例值: 202205256843192280647118
     */
    private String outTradeNo;

    /**
     * 商户日期
     * 该参数做交易与查询时需要一致
     * 该日期需在当日的前后一天时间范围之内
     * 字节长度: String(8,8)
     * 必填: 是
     * 示例值: 20180525
     */
    private String shopdate;

    /**
     * 订单备注
     * 字节长度: String(1,250)
     * 必填: 是
     */
    private String subject;

    /**
     * 订单金额
     * 该笔订单的资金总额，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number(10,2)
     * 必填: 是
     * 示例值: 100
     */
    private BigDecimal totalAmount;

    /**
     * 收款商户号（银盛支付生成并下发）
     * 字节长度: String(1,20)
     * 必填: 是
     */
    private String sellerId;

    /**
     * 收款商户号对应商户名称
     * 字节长度: String(1,50)
     * 必填: 否
     */
    private String sellerName;

    /**
     * 超时时间
     * 设置未付款交易的超时时间，一旦超时，该笔交易就会自动被关闭
     * 取值范围：1m～15d。m-分钟，h-小时，d-天
     * 该参数数值不接受小数点，如1.5h，可转换为90m
     * 字节长度: String(2,6)
     * 必填: 是
     * 示例值: 96h
     */
    private String timeoutExpress;

    /**
     * 业务代码
     * 请联系银盛客户经理获取
     * 注意：业务代码非固定值，不同到账方式需要传不同的业务代码
     * 字节长度: String(1,10)
     * 必填: 是
     */
    private String businessCode;

    /**
     * 用户端IP
     * 必须传正确的用户端ip
     * 字节长度: String(16)
     * 必填: 是
     * 示例值: 123.12.12.123
     */
    private String spbillCreateIp;

    /**
     * 行别
     * 银联扫码-9001002
     * 字节长度: String(7,9)
     * 必填: 是
     */
    private String bankType;

    /**
     * 银联用户标识
     * 用户在APP上的标识号，用来提供给收款方，并在收款方发起交易时回传给付款
     * 字节长度: String(128)
     * 必填: 是
     */
    private String userId;

    /**
     * 是否允许多次支付
     * Y：允许
     * N：不允许
     * 当参数为空或者Y时，默认该笔订单交易状态非成功状态时，支持选择其他支付方式继续付款
     * 当为N时表示该笔订单交易状态为失败状态时，不支持选择其他支付方式继续付款
     * 字节长度: String(2)
     * 必填: 是
     */
    private String allowRepeatPay;

    /**
     * 公用回传参数
     * 商户自定义数据域，原样返回
     * 字节长度: String(2000)
     * 必填: 否
     */
    private String extraCommonParam;

    /**
     * 币种
     * 字节长度: String(3)
     * 必填: 否
     * 默认CNY（人民币）
     */
    private String currency = "CNY";

    /**
     * 业务扩展参数
     * 一个json字符串
     * order_mode订单模式，暂时可选的值为:00 代表购物车模式
     * seller_list参与分账的收款方信息数组，每个元素包含seller_id收款方银盛支付用户号
     * 实时分账业务，order_mode和seller_list均不能为空，order_mode的值必须为00
     * 字节长度: String(500)
     * 必填: 否
     */
    private String extendParams;

    /**
     * 服务商信息编号
     * 字节长度: String
     * 必填: 否
     */
    private String corpSrcSuperieor;

    /**
     * 二级商户信息
     * Json格式
     * 如果有值则二级商户信息都不能为空，如果没值则都不能有值
     * 必填: 否
     */
    private SubMerchantInfo subMerchant;

    /**
     * 收货人信息
     * Json格式
     * 必填: 否
     */
    private ConsigneeInfo consigneeInfo;

    /**
     * 终端号
     * 自定义 8位整数
     * 字节长度: String(8)
     * 必填: 否
     */
    private String deviceInfo;

    /**
     * 终端信息
     * 字节长度: String(300)
     * 必填: 否
     */
    private String terminalInfo;

    /**
     * 是否限制信用卡
     * 值为1表示禁用信用卡，0或为空表示不限制
     * 字节长度: String(2)
     * 必填: 否
     */
    private String limitCreditPay;

    /**
     * 失败通知地址
     * 交易状态为失败时，银盛支付服务器主动通知商户网站里指定的页面http路径
     * 支持多个url进行异步通知，多个url用分隔符","分开，格式如：url1,url2,url3
     * 注：只有不允许重复支付的交易才会通知
     * 字节长度: String(190)
     * 必填: 否
     */
    private String failNotifyUrl;

    /**
     * 子商户IP
     * 字节长度: String(16)
     * 必填: 否
     * 示例值: 112.112.112.112
     */
    private String submerIp;

    /**
     * 付款方GPS信息
     * 必填: 否
     */
    private GpsInformation gps;

    /**
     * 商户自主营销信息
     * json格式
     * coupon_id优惠券id、marketing_source_id营销来源id
     * 字节长度: String
     * 必填: 否
     */
    private String merchantMarketingInfo;

    /**
     * 二级商户信息
     */
    @Data
    public static class SubMerchantInfo {
        /**
         * 二级商户名称
         * 支持25个中文
         * 字节长度: String(50)
         * 必填: 否
         */
        private String merName;

        /**
         * 二级商户简称
         * 支持25个中文
         * 字节长度: String(50)
         * 必填: 否
         */
        private String merShortName;

        /**
         * 二级商户地址
         * 支持100个中文
         * 字节长度: String(200)
         * 必填: 否
         */
        private String merAddr;

        /**
         * 固定电话/手机号码二选一
         * 字节长度: String(13)
         * 必填: 否
         */
        private String telephone;

        /**
         * 二级商户编号
         * 字节长度: String(32)
         * 必填: 否
         */
        private String merNo;

        /**
         * 类目
         * 按附件内容输入类目编号
         * 字节长度: String(20)
         * 必填: 否
         */
        private String category;

        /**
         * 身份证号
         * 只支持身份证格式
         * 如果签名方式为RSA，则用DES加密，密钥为商户号前8位，不足8位在商户号前补空格
         * 如果签名方式为SM，则用SM加密
         * 字节长度: String(15,18)
         * 必填: 否
         */
        private String mrchntCertId;
    }

    /**
     * 收货人信息
     */
    @Data
    public static class ConsigneeInfo {
        /**
         * 收货人姓名
         * 字节长度: String(150)
         * 必填: 否
         */
        private String consigneeName;

        /**
         * 收货地址
         * 字节长度: String(200)
         * 必填: 否
         */
        private String consigneeAddr;

        /**
         * 物流配送信息（物流名称+订单号）
         * 字节长度: String(200)
         * 必填: 否
         */
        private String transportationInfo;

        /**
         * 商品名称
         * 字节长度: String(150)
         * 必填: 否
         */
        private String commodityName;

        /**
         * 商品数量
         * 字节长度: String(10)
         * 必填: 否
         */
        private String commodityNumber;
    }

    /**
     * GPS信息
     */
    @Data
    public static class GpsInformation {
        /**
         * 纬度
         * 范围-90~90
         * 必填: 否
         */
        private Double latitude;

        /**
         * 经度
         * 范围-180~180
         * 必填: 否
         */
        private Double longitude;
    }
} 