package com.fshows.ysepay.model.income;

import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import lombok.Data;

/**
 * 法人信息
 */
@Data
public class CrpInfo {
	
	/**
	 * 法人证件号
	 * 字节长度: String(30)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 30)
	private String crpCertNo;
	
	/**
	 * 法人证件类型
	 * 00：身份证 06：国外护照 07：港澳通行证 08：台胞通行证
	 * 字节长度: String(2)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 2)
	private String crpCertType;
	
	/**
	 * 证件开始日期
	 * 格式yyyyMMdd
	 * 字节长度: String(8)
	 * 必填: 是
	 */
	@NotBlank
	@Size(min = 8, max = 8)
	private String certBgn;
	
	/**
	 * 证件有效期
	 * 格式yyyyMMdd，如果为长期或者永久，请填值"29991231"
	 * 字节长度: String(8)
	 * 必填: 是
	 */
	@NotBlank
	@Size(min = 8, max = 8)
	private String certExpire;
	
	/**
	 * 法人国籍
	 * 默认中国(249)
	 * 字节长度: String(3)
	 * 必填: 否
	 */
	@Size(max = 3)
	private String crpNati;
	
	/**
	 * 法人姓名
	 * 字节长度: String(20)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 20)
	private String crpNm;
	
	/**
	 * 法人手机号
	 * 字节长度: String(11)
	 * 必填: 是
	 */
	@NotBlank
	@Size(max = 11)
	private String crpPhone;
	
	/**
	 * 法人地址
	 * 字节长度: String(100)
	 * 必填: 否
	 */
	@Size(max = 100)
	private String crpAddr;
	
	/**
	 * 实际控制人
	 * 默认同法人信息
	 * 必填: 否
	 */
	private ActContrInfo actContrInfo;
	
	/**
	 * 被授权人信息
	 * 法人结算同法人信息,非法人结算同开户人信息
	 * 必填: 否
	 */
	private AuthInfo authInfo;
	
	/**
	 * 受益人
	 * 默认同法人，最多三个受益人
	 * 必填: 否
	 */
	private List<BnfInfo> bnfList;
}

@Data
class ActContrInfo {
	/**
	 * 实际控制人姓名
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String name;
	
	/**
	 * 实际控制人证件类型
	 * 字节长度: String(2)
	 * 必填: 否
	 */
	@Size(max = 2)
	private String certType;
	
	/**
	 * 实际控制人证件号
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String certNo;
	
	/**
	 * 实际控制人证件起始日期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certBgn;
	
	/**
	 * 实际控制人证件有效期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certExpire;
	
	/**
	 * 实际控制人证件地址
	 * 字节长度: String(100)
	 * 必填: 否
	 */
	@Size(max = 100)
	private String addr;
}

@Data
class AuthInfo {
	/**
	 * 被授权姓名
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String name;
	
	/**
	 * 被授权证件类型
	 * 暂时只支持 00 身份证
	 * 字节长度: String(2)
	 * 必填: 否
	 */
	@Size(max = 2)
	private String certType;
	
	/**
	 * 被授权人证件号
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String certNo;
	
	/**
	 * 被授权人证件开始日期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certBgn;
	
	/**
	 * 被授权人证件有效期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certExpire;
	
	/**
	 * 被授权人证件地址
	 * 字节长度: String(100)
	 * 必填: 否
	 */
	@Size(max = 100)
	private String addr;
}

@Data
class BnfInfo {
	/**
	 * 受益人姓名
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String name;
	
	/**
	 * 受益人证件类型
	 * 暂时只支持 00 身份证
	 * 字节长度: String(2)
	 * 必填: 否
	 */
	@Size(max = 2)
	private String certType;
	
	/**
	 * 受益人证件号
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String certNo;
	
	/**
	 * 受益人开始日期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certBgn;
	
	/**
	 * 受益人证件有效期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certExpire;
	
	/**
	 * 受益人地址
	 * 字节长度: String(100)
	 * 必填: 否
	 */
	@Size(max = 100)
	private String addr;
} 