/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.order;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 聚合支付统一下单
 *
 * @author
 * @version YopAggpayPrepayResponse.java, v 0.1 2023-04-20 10:33:49
 */
@Data
public class YopAggpayPrepayResponse implements Serializable {

    private static final long serialVersionUID = -2213838555676681322L;

    /**
     * 返回码
     *
     * (选填)
     */
    private String code;

    /**
     * 返回信息
     *
     * (选填)
     */
    private String message;

    /**
     * 商户收款请求号
     *
     * (选填)
     */
    private String orderId;

    /**
     * 易宝收款订单号
     *
     * (选填)
     */
    private String uniqueOrderNo;

    /**
     * 渠道侧商户请求号<br>支付机构在微信侧的外部商户订单号，用于服务商用于点金计划商户小票功能
     *
     * (选填)
     */
    private String bankOrderId;

    /**
     * 预支付标识信息 <a href="https://open.yeepay.com/docs/v2/products/ptssfk/others/5feb010d6d313b001b79abf8/index.html">prePayTn使用方式</a>
     *
     * (选填)
     */
    private String prePayTn;

}