/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.order;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.order.YopTradeRefundQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 * 查询退款
 * @author
 * @version YopTradeRefundQueryRequest.java, v 0.1 2023-04-20 11:46:42
 */
@Data
public class YopTradeRefundQueryRequest extends YopBizRequest<YopTradeRefundQueryResponse> {

    private static final long serialVersionUID = -2213838555476216701L;

    /**
     * 收款商户编号(示例值：10012426723)
     *
     * (选填)
     */
    @Length(max = 11, message = "merchantNo长度不能超过11")
    private String merchantNo;

    /**
     * 收款交易对应的商户收款请求号
     *
     * (选填)
     */
    @Length(max = 64, message = "orderId长度不能超过64")
    private String orderId;

    /**
     * 商户退款请求号。可包含字母、数字、下划线；需要保证在商户端不重复。
     *
     * (选填)
     */
    @Length(max = 64, message = "refundRequestId长度不能超过64")
    private String refundRequestId;

    /**
     * 易宝退款订单号<br>商户退款请求对应在易宝的退款单号
     *
     * (选填)
     */
    @Length(max = 32, message = "uniqueRefundNo长度不能超过32")
    private String uniqueRefundNo;

    @Override
    public Class<YopTradeRefundQueryResponse> getResponseClass() {
        return YopTradeRefundQueryResponse.class;
    }
}