/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.order;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.order.YopAggpayPayResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 *
 *
 * @author
 * @version YopAggpayPayRequest.java, v 0.1 2023-04-22 11:52:22
 */
@Data
public class YopAggpayPayRequest extends YopBizRequest<YopAggpayPayResponse> {

    private static final long serialVersionUID = -2213838555373241067L;

    /**
     * 商户编号。收单主体商编，平台商或服务商下的子商户，普通特约商户(示例值：10040054321)
     *
     * (选填)
     */
    @Length(max = 11, message = "merchantNo长度不能超过11")
    private String merchantNo;

    /**
     * 商户收款请求号。商户系统内部生成的订单号，需要保持在同一个商户下唯一(示例值：orderId12345)
     *
     * (选填)
     */
    @Length(max = 64, message = "orderId长度不能超过64")
    private String orderId;

    /**
     * 订单金额。业务上是必须参数，单位： 元， 两位小数， 最低 0.01(示例值：0.01)
     *
     * (选填)
     */
    private BigDecimal orderAmount;

    /**
     * 订单截止时间。格式"yyyy-MM-dd HH:mm:ss"<br>不传默认一天(示例值：2021-01-01 12:34:56)
     *
     * (选填)
     */
    private String expiredTime;

    /**
     * 支付结果通知地址<br>业务上是必须参数，支付成功服务器回调地址：支付成功通知、超时通知、失败通知。请参考<a href="#anchor7">支付结果通知</a>(示例值：https://notify.merchant.com/xxx)
     *
     * (选填)
     */
    @Length(max = 200, message = "notifyUrl长度不能超过200")
    private String notifyUrl;

    /**
     * 自定义对账备注。商户可以自定义自身业务需要使用的字段： 如对账时定义该订单应属的会计科目
     *
     * (选填)
     */
    @Length(max = 85, message = "memo长度不能超过85")
    private String memo;

    /**
     * 商品名称，如：旺仔牛奶<br>特殊说明：由于微信渠道侧限制，如微信支付时该字段将自动截取前42个字符送渠道(示例值：旺仔牛奶)
     *
     * (选填)
     */
    @Length(max = 85, message = "goodsName长度不能超过85")
    private String goodsName;

    /**
     * 分账订单标记<br>DELAY_SETTLE:需要分账<br>REAL_TIME:不需要分账(示例值：REAL_TIME)
     *
     * (选填)
     */
    private String fundProcessType;

    /**
     * 支付方式类型<br>MERCHANT_SCAN:付款码支付<br>SDK_PAY:SDK支付(示例值：MERCHANT_SCAN)
     *
     * (选填)
     */
    private String payWay;

    /**
     * 渠道类型<br>WECHAT:微信<br>ALIPAY:支付宝<br>UNIONPAY:银联云闪付<br>APPLEPAY:苹果闪付<br>DCEP:数字人民币(示例值：WECHAT)
     *
     * (选填)
     */
    private String channel;

    /**
     * 场景<br>OFFLINE:线下<br>渠道类型为银联时，不必传(示例值：OFFLINE)
     *
     * (选填)
     */
    private String scene;

    /**
     * 获取的用户授权码<br>(ApplePay对应paymentToken解密后的emvData)(示例值：authCode123)
     *
     * (选填)
     */
    private String authCode;

    /**
     * 微信公众号ID。<br>1）如需获取付款用户的用户ID时需要传入<br>2）若商户预先调用了付款码查询用户ID接口，则appId需要传入，且需要与付款码查询用户ID接口传入的appId保持一致(示例值：appId12345)
     *
     * (选填)
     */
    private String appId;

    /**
     * 用户IP<br>用户真实IP地址<br>已获批开通账户通的平台商，若accountLinkInfo不为空，此userIp必须与accountLinkInfo中的token所包含的IP一致(示例值：123.123.123.123)
     *
     * (选填)
     */
    private String userIp;

    /**
     * 终端号id(示例值：00000000)
     *
     * (选填)
     */
    private String terminalId;

    /**
     * 商家终端场景信息(示例值：{"storeId":"门店id","storeName":"门店名称","operatorId":"商户操作员编号","alipayStoreId":"支付宝的店铺编号","areaCode":"门店行政区划码","address":"门店详细地址"})
     *
     * (选填)
     */
    private String terminalSceneInfo;

    /**
     * 渠道指定支付信息 1、支持花呗分期 hbFqNum：期数；枚举值：3，6，12 hbFqSellerPercent：手续费费率；请传入0，表示用户承担 sysServiceProviderId：系统商PID，作为系统商返佣数据提取的依据；一般无需传入 2、是否企业支付 isEnterprisePay：是否企业支付，如需要返回支付宝企业支付信息时传入；枚举值：Y、N(示例值：{"hbFqNum":"3","hbFqSellerPercent":"0","sysServiceProviderId":"","isEnterprisePay":"N"})
     *
     * (选填)
     */
    private String channelSpecifiedInfo;

    /**
     * 渠道优惠信息。订单需参与渠道指定优惠时传入，如微信单品券<br><a href="https://open.yeepay.com/docs/v2/products/fwssfk/others/5f59fc1720289f001ba82528/5fed4bc56d313b001b79abfd/index.html">渠道优惠信息JSON说明</a>
     *
     * (选填)
     */
    private String channelPromotionInfo;

    /**
     * 限制付款人信息<br>特殊行业需要支付实名场景下使用，如保险的特殊险种需要付款人和投保人实名条件下可以使用<br><a href="https://open.yeepay.com/docs/products/bzshsfk/others/5f3cefa0a92810001be76426/63a1b711f9a122006f1b5379">聚合限制付款人信息json说明</a>(示例值：{"identityVerifyType":"Y","payerIdType":"IDENTITY_CARD","payerNumber":"234512198006252456","payerName":"名字"})
     *
     * (选填)
     */
    private String identityInfo;

    /**
     * 是否限制贷记卡<br>Y:仅借记卡可以支付<br>N:借贷记卡均可支付(示例值：N)
     *
     * (选填)
     */
    private String limitCredit;

    /**
     * 下单接口返回的token<br>如果商户使用先下单再支付模式，请传入下单接口返回的token(示例值：83BCDF29CFACB4411533080B67864EF8C907CCDC5E10A707C285FEA10CDB8221)
     *
     * (选填)
     */
    private String token;

    /**
     * 易宝订单号<br>如果商户使用先下单再支付模式，请传入下单接口返回的易宝订单号<br>同时传入易宝订单号和token，将以易宝订单号为准(示例值：1012202101070000001989946571)
     *
     * (选填)
     */
    private String uniqueOrderNo;

    /**
     * 清算回调地址<br>清算成功服务器回调地址，不传则不通知。详见<a href="https://open.yeepay.com/docs/products/ptssfk/spis/5fc9ae6896818f001b300bce">清算结果通知</a>
     *
     * (选填)
     */
    private String csUrl;

    /**
     * ApplePay支付密码，免密情况下可不填，对应paymentToken解密后的encryptedPINData
     *
     * (选填)
     */
    private String encryptedPINData;

    /**
     * 卡号，ApplePay对应paymentToken解密后的emvData
     *
     * (选填)
     */
    private String payerAccountNo;

    /**
     * 合作银行信息：<br>JSON字符串；已获批开通账户通的平台商可传入此字段，否则请勿传值<br>accountProvider:合作银行<br> token:商户与银行约定令牌(示例值：{accountProvider":"BOL","token":"xxx"})
     *
     * (选填)
     */
    private String accountLinkInfo;

    /**
     * 银行编码<br>渠道类型（channel）为数字人民币（DCEP）时必填<br>BOC:中国银行(示例值：BOC)
     *
     * (选填)
     */
    private String bankCode;

    /**
     * 自定义参数信息<br>json格式
     *
     * (选填)
     */
    private String businessInfo;

    @Override
    public Class<YopAggpayPayResponse> getResponseClass() {
        return YopAggpayPayResponse.class;
    }
}