/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.client;

import com.fshows.yeepay.sdk.client.impl.YopApiDefinition;
import com.fshows.yeepay.sdk.exception.YopPayException;
import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.request.sign.YopSignRequest;
import com.fshows.yeepay.sdk.response.YopBaseResponse;
import com.fshows.yeepay.sdk.response.sign.YopSignResponse;

/**
 * @author youmingming
 * @version YopBaseClient.java, v 0.1 2022-02-09 下午10:35 youmingming
 */
public interface YopBaseClient {
    /**
     * 请求易宝接口
     *
     * @param request          请求参数
     * @param yopApiDefinition 方法枚举
     * @param <R>              返参
     * @return UmBaseResponse
     * <p>
     * UmpayApiDefinition api方法请参考下列API枚举
     */
    <R> YopBaseResponse<R> execute(YopBizRequest<R> request, YopApiDefinition yopApiDefinition) throws YopPayException;

    YopSignResponse getYopSignData(YopSignRequest request) throws YopPayException;
}
