/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.sdk.util;

import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.encrypt.CertTypeEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigestAlgEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigitalSignatureDTO;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.HttpMethodName;
import com.yeepay.g3.sdk.yop.http.HttpUtils;
import com.yeepay.g3.sdk.yop.utils.CheckUtils;
import com.yeepay.g3.sdk.yop.utils.DateUtils;
import com.yeepay.g3.sdk.yop.utils.DigitalEnvelopeUtils;
import com.yeepay.g3.sdk.yop.utils.Exceptions;
import com.yeepay.g3.sdk.yop.utils.RSAKeyUtils;
import com.yeepay.g3.sdk.yop.utils.UUIDUtils;
import com.yeepay.shade.com.google.common.base.Joiner;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.com.google.common.collect.Multimap;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class YopSignUtil {
    protected static String getUUID() {
        return UUIDUtils.compressV4UUID();
    }

    public static void getSignData(String apiUri, YopRequest request, HttpMethodName method) {
        CheckUtils.checkApiUri((String)apiUri);
        YopSignUtil.sign(apiUri, request, method);
    }

    private static void sign(String apiUri, YopRequest request, HttpMethodName httpMethod) {
        PrivateKey isvPrivateKey;
        String appKey = request.getAppSdkConfig().getAppKey();
        String timestamp = DateUtils.formatAlternateIso8601Date((Date)new Date());
        Map headers = request.getHeaders();
        headers.put("x-yop-session-id", YopSignUtil.getUUID());
        headers.put("x-yop-request-id", YopSignUtil.getUUID());
        HashSet<String> headersToSignSet = new HashSet<String>();
        headersToSignSet.add("x-yop-request-id");
        String authString = "yop-auth-v2/" + appKey + "/" + timestamp + "/" + "1800";
        String canonicalURI = HttpUtils.getCanonicalURIPath((String)apiUri);
        String canonicalQueryString = HttpUtils.getCanonicalQueryString((Multimap)request.getParams(), (boolean)true);
        SortedMap<String, String> headersToSign = YopSignUtil.getHeadersToSign(headers, headersToSignSet);
        String canonicalHeader = YopSignUtil.getCanonicalHeaders(headersToSign);
        String signedHeaders = Joiner.on((char)';').join(headersToSign.keySet());
        signedHeaders = signedHeaders.trim().toLowerCase();
        String canonicalRequest = authString + "\n" + httpMethod + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeader;
        if (StringUtils.length((CharSequence)request.getSecretKey()) > 128) {
            try {
                isvPrivateKey = RSAKeyUtils.string2PrivateKey((String)request.getSecretKey());
            }
            catch (NoSuchAlgorithmException var16) {
                throw Exceptions.unchecked((Throwable)var16);
            }
            catch (InvalidKeySpecException var17) {
                throw Exceptions.unchecked((Throwable)var17);
            }
        } else {
            isvPrivateKey = request.getAppSdkConfig().getDefaultIsvPrivateKey();
        }
        if (isvPrivateKey == null) {
            throw new YopClientException("Can't init ISV private key!");
        }
        DigitalSignatureDTO digitalSignatureDTO = new DigitalSignatureDTO();
        digitalSignatureDTO.setPlainText(canonicalRequest);
        digitalSignatureDTO.setCertType(CertTypeEnum.RSA2048);
        digitalSignatureDTO.setDigestAlg(DigestAlgEnum.SHA256);
        digitalSignatureDTO = DigitalEnvelopeUtils.sign((DigitalSignatureDTO)digitalSignatureDTO, (PrivateKey)isvPrivateKey);
        headers.put("Authorization", "YOP-RSA2048-SHA256 yop-auth-v2/" + appKey + "/" + timestamp + "/" + "1800" + "/" + signedHeaders + "/" + digitalSignatureDTO.getSignature());
    }

    private static String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(HttpUtils.normalize((String)key.trim().toLowerCase()) + ':' + HttpUtils.normalize((String)value.trim()));
        }
        Collections.sort(headerStrings);
        return Joiner.on((char)'\n').join((Iterable)headerStrings);
    }

    private static SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet tempSet = Sets.newHashSet();
            for (String header : headersToSign) {
                tempSet.add(header.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        Iterator<Object> var5 = headers.entrySet().iterator();
        while (var5.hasNext()) {
            Map.Entry entry = (Map.Entry)var5.next();
            String key = (String)entry.getKey();
            if (entry.getValue() == null || ((String)entry.getValue()).isEmpty() || (headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key)) && (headersToSign != null || !YopSignUtil.isDefaultHeaderToSign(key))) continue;
            ret.put(key, (String)entry.getValue());
        }
        return ret;
    }

    private static boolean isDefaultHeaderToSign(String header) {
        return (header = header.trim().toLowerCase()).startsWith("x-yop-") || Sets.newHashSet().contains(header);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YopSignUtil)) {
            return false;
        }
        YopSignUtil other = (YopSignUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof YopSignUtil;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "YopSignUtil()";
    }
}

