/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.order;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version YopAggpayPayResponse.java, v 0.1 2023-04-22 11:52:23
 */
@Data
public class YopAggpayPayResponse implements Serializable {

    private static final long serialVersionUID = -2213838555628417730L;


    /**
     * 返回码
     *
     * (选填)
     */
    private String code;

    /**
     * 返回信息
     *
     * (选填)
     */
    private String message;

    /**
     * 商户收款请求号
     *
     * (选填)
     */
    private String orderId;

    /**
     * 易宝收款订单号
     *
     * (选填)
     */
    private String uniqueOrderNo;

    /**
     * 渠道侧商户请求号
     *
     * (选填)
     */
    private String bankOrderId;

    /**
     * 状态<br>PROCESSING:处理中（内部系统处理超时会出现）<br>WAITPAY:等待用户输入密码<br>SUCCESS:支付成功<br>FAIL:支付失败
     *
     * (选填)
     */
    private String status;

    /**
     * 终端授权方式<br>MICROPAY:付款码支付<br>FACEPAY:刷脸支付
     *
     * (选填)
     */
    private String terminalPayType;

    /**
     * 渠道的支付完成时间，同用户的支付账单显示完成时间一致
     *
     * (选填)
     */
    private String paySuccessTime;

    /**
     * 用户ID<br>微信的openId、支付宝的userId
     *
     * (选填)
     */
    private String userId;

    /**
     * 付款银行
     *
     * (选填)
     */
    private String bankId;

}