/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.merchant;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.merchant.YopWechatConfigQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version YopWechatConfigQueryReqeust.java, v 0.1 2023-05-08 14:09:41
 */
@Data
public class YopWechatConfigQueryReqeust extends YopBizRequest<YopWechatConfigQueryResponse> {

    private static final long serialVersionUID = -2213838555816775248L;


    /**
     * 发起方商户编号
     *
     * (选填)
     */
    @Length(max = 11, message = "parentMerchantNo长度不能超过11")
    private String parentMerchantNo;

    /**
     * 商户编号
     *
     * (选填)
     */
    @Length(max = 11, message = "merchantNo长度不能超过11")
    private String merchantNo;

    /**
     * appId类型<br>OFFICIAL_ACCOUNT:公众号<br>MINI_PROGRAM:小程序
     *
     * (选填)
     */
    private String appIdType;

    @Override
    public Class<YopWechatConfigQueryResponse> getResponseClass() {
        return YopWechatConfigQueryResponse.class;
    }
}