/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.account;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.account.YopSettleQueryResponse;
import com.fshows.yeepay.sdk.response.merchant.YopWechatConfigQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version YopSettleQueryRequest.java, v 0.1 2024-04-22 18:19:00
 */
@Data
public class YopSettleQueryRequest extends YopBizRequest<YopSettleQueryResponse> {

    private static final long serialVersionUID = -2213838555104147883L;


    /**
     * 发起方商编
     *
     * (选填)
     */
    private String parentMerchantNo;

    /**
     * 商户编号
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 结算请求号(结算请求号与结算申请起止时间二选一必填)
     *
     * (选填)
     */
    private String settleRequestNo;

    /**
     * 结算申请起始时间（结算申请起止时间与结算请求号二选一必填）(示例值：2020-12-01 00:00:00)
     *
     * (选填)
     */
    private String settleRequestBeginTime;

    /**
     * 结算申请截止时间（结算申请起止时间与结算请求号二选一必填）(示例值：2020-12-01 00:00:00)
     *
     * (选填)
     */
    private String settleRequestEndTime;

    @Override
    public Class<YopSettleQueryResponse> getResponseClass() {
        return YopSettleQueryResponse.class;
    }
}