/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version YopWechatConfigAddResponse.java, v 0.1 2023-05-06 17:14:49
 */
@Data
public class YopWechatConfigAddResponse implements Serializable {

    private static final long serialVersionUID = -2213838555636044681L;


    /**
     * 返回码
     *
     * (选填)
     */
    private String code;

    /**
     * 返回信息描述
     *
     * (选填)
     */
    private String message;

    /**
     * 受理状态<br>ACCEPT:受理成功<br>SUCCESS:配置成功<br>FAILED:配置失败
     *
     * (选填)
     */
    private String status;

    /**
     * 配置结果<br>reportMerchantNo 报备商户号<br>tradeAuthDirList 支付授权目录列表<br>tradeAuthDir 支付授权目录<br>status 配置状态<br>failReason 失败原因<br>appId 支付appId<br>appSecret 支付appSecret<br>appIdType appId类型<br>subscribeAppId 推荐关注appId(示例值：[{"tradeAuthDirList":[{"failReason":"xxx","tradeAuthDir":"xxx","status":"xxx"}],"appIdList":[{"appIdType":"xxx","subscribeAppId":"xxx","appId":"xxx","appSecret":"xxx","failReason":"xxx","status":"xxx"}],"reportMerchantNo":"xxx"}])
     *
     * (选填)
     */
    private String configResult;

}